class QECoreIcon:

    def __init__(self, mime_type, encoding, data):
        self.mime_type = mime_type
        self.encoding = encoding
        self.data = data

    def to_src(self):
        return f"data:{self.mime_type};{self.encoding},{self.data}"


qecore_icons = {
    "x11": QECoreIcon("image/svg+xml", "base64", """
PCEtLSBDcmVhdGVkIHdpdGggSW5rc2NhcGUgKGh0dHA6Ly93d3cuaW5rc2NhcGUub3JnLykgLS0+
Cgo8c3ZnCiAgIHhtbG5zOnN2Zz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5z
PSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIKICAgdmVyc2lvbj0iMS4xIgogICB3aWR0aD0i
Mjc1IgogICBoZWlnaHQ9IjI3NSIKICAgaWQ9InN2ZzIiPgogIDxkZWZzCiAgICAgaWQ9ImRlZnM0
IiAvPgogIDxnCiAgICAgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTI5NS4xNzg1NywtMzM4LjYxMjE3
KSIKICAgICBpZD0ibGF5ZXIxIj4KICAgIDxwYXRoCiAgICAgICBkPSJtIDI5Ni43ODU3MSw2MTIu
NjMwMDMgYyAwLDAgMTA0LjA2Mjg1LC0xMzIuNzg1OSAxMDQuMDYyODUsLTEzMi43ODU5IDAsMCAt
MTA0LjA2Mjg1LC0xNDAuMjQ5ODIgLTEwNC4wNjI4NSwtMTQwLjI0OTgyIGwgNjcuMzAyOTksMCBj
IDAsMCA4My4zNDc0OSwxMTMuNDg4MjYgODMuMzQ3NDksMTEzLjQ4ODI2IGwgLTEyNi44NjQ3Nywx
NTkuNTQ3NDYgLTIzLjc4NTcxLDAgeiBNIDQxNy4yODc5NCw1MDAuMDY1NzggNTQ0LjExNjYyLDMz
OS41OTQzMSBjIDAsMCAyNC40NTQ4MSwwIDI0LjQ1NDgxLDAgTCA0NjQuNDc3NDksNDcxLjI2NTc4
IGMgMCwwIDEwNC4wOTM5NCwxNDEuMzY0MjUgMTA0LjA5Mzk0LDE0MS4zNjQyNSBsIC02Ny4zMDM1
NywwIGMgMCwwIC04My45Nzk5MiwtMTEyLjU2NDI1IC04My45Nzk5MiwtMTEyLjU2NDI1IHoiCiAg
ICAgICBpZD0icGF0aDI4MzAiCiAgICAgICBzdHlsZT0iZmlsbDojMDAwMDAwIiAvPgogIDwvZz4K
PC9zdmc+Cg==
""".replace("\n", "")),

    "wayland": QECoreIcon("image/svg+xml", "base64", """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==
""".replace("\n", "")),
}
