# Copyright (c) Microsoft. All rights reserved.
from typing import Optional

from semantic_kernel.connectors.ai.open_ai.contents.open_ai_chat_message_content import OpenAIChatMessageContent


class AzureChatMessageContent(OpenAIChatMessageContent):
    """This is the class for Azure OpenAI chat message response content.

    Args:
        inner_content: ChatCompletion - The inner content of the response,
            this should hold all the information from the response so even
            when not creating a subclass a developer can leverage the full thing.
        ai_model_id: Optional[str] - The id of the AI model that generated this response.
        metadata: Dict[str, Any] - Any metadata that should be attached to the response.
        role: ChatRole - The role of the chat message.
        content: Optional[str] - The text of the response.
        encoding: Optional[str] - The encoding of the text.
        function_call: Optional[FunctionCall] - The function call that was generated by this response.
        tool_calls: Optional[List[ToolCall]] - The tool calls that were generated by this response.
        tool_message: Optional[str] - The content of the tool message generated by the extensions API.

    Methods:
        __str__: Returns the content of the response.
    """

    tool_message: Optional[str] = None
