"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class GetUnifiedIntegrationLoginRequestTypedDict(TypedDict):
    integration_type: str
    r"""Type of the supported integration"""
    workspace_id: str
    r"""The ID of the workspace"""
    env: NotRequired[str]
    failure_redirect: NotRequired[str]
    r"""The URL where you want the user to be redirect to after an unsuccessful authentication. An \"error\" variable will be appended."""
    redirect: NotRequired[bool]
    state: NotRequired[str]
    r"""Extra state to send back to your success URL"""
    success_redirect: NotRequired[str]
    r"""The URL where you want the user to be redirect to after a successful authentication/sign-in.  A \"jwt\" parameter will be appended to the URL which will contain a name and email of the user who just signed-in."""


class GetUnifiedIntegrationLoginRequest(BaseModel):
    integration_type: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Type of the supported integration"""

    workspace_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the workspace"""

    env: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    failure_redirect: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL where you want the user to be redirect to after an unsuccessful authentication. An \"error\" variable will be appended."""

    redirect: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    state: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Extra state to send back to your success URL"""

    success_redirect: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL where you want the user to be redirect to after a successful authentication/sign-in.  A \"jwt\" parameter will be appended to the URL which will contain a name and email of the user who just signed-in."""


class GetUnifiedIntegrationLoginResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    res: NotRequired[str]
    r"""Successful"""


class GetUnifiedIntegrationLoginResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    res: Optional[str] = None
    r"""Successful"""
