"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import enrichcompany as shared_enrichcompany
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class ListEnrichCompaniesRequestTypedDict(TypedDict):
    connection_id: str
    r"""ID of the connection"""
    domain: NotRequired[str]
    r"""The domain of the company to search"""
    name: NotRequired[str]
    r"""The name of the company to search"""


class ListEnrichCompaniesRequest(BaseModel):
    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    domain: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The domain of the company to search"""

    name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The name of the company to search"""


class ListEnrichCompaniesResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    enrich_company: NotRequired[shared_enrichcompany.EnrichCompanyTypedDict]
    r"""Successful"""


class ListEnrichCompaniesResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    enrich_company: Optional[shared_enrichcompany.EnrichCompany] = None
    r"""Successful"""
