"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import connection as shared_connection
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import FieldMetadata, QueryParamMetadata


class Categories(str, Enum):
    PASSTHROUGH = "passthrough"
    HRIS = "hris"
    ATS = "ats"
    AUTH = "auth"
    CRM = "crm"
    ENRICH = "enrich"
    MARTECH = "martech"
    TICKETING = "ticketing"
    UC = "uc"
    ACCOUNTING = "accounting"
    STORAGE = "storage"
    COMMERCE = "commerce"
    PAYMENT = "payment"
    GENAI = "genai"
    MESSAGING = "messaging"
    KMS = "kms"
    TASK = "task"
    SCIM = "scim"
    LMS = "lms"
    REPO = "repo"
    METADATA = "metadata"
    CALENDAR = "calendar"


class ListUnifiedConnectionsRequestTypedDict(TypedDict):
    categories: NotRequired[List[Categories]]
    r"""Filter the results on these categories"""
    env: NotRequired[str]
    external_xref: NotRequired[str]
    r"""Filter the results to only those integrations for your user referenced by this value"""
    limit: NotRequired[float]
    offset: NotRequired[float]
    order: NotRequired[str]
    sort: NotRequired[str]
    updated_gte: NotRequired[str]
    r"""Return only results whose updated date is equal or greater to this value"""


class ListUnifiedConnectionsRequest(BaseModel):
    categories: Annotated[
        Optional[List[Categories]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results on these categories"""

    env: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    external_xref: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the results to only those integrations for your user referenced by this value"""

    limit: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    offset: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    updated_gte: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Return only results whose updated date is equal or greater to this value"""


class ListUnifiedConnectionsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    connections: NotRequired[List[shared_connection.ConnectionTypedDict]]
    r"""Successful"""


class ListUnifiedConnectionsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    connections: Optional[List[shared_connection.Connection]] = None
    r"""Successful"""
