"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import scimuser as shared_scimuser
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import FieldMetadata, PathParamMetadata, RequestMetadata


class PatchScimUsersRequestTypedDict(TypedDict):
    scim_user: shared_scimuser.ScimUserTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the User"""


class PatchScimUsersRequest(BaseModel):
    scim_user: Annotated[
        shared_scimuser.ScimUser,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the User"""


class PatchScimUsersResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    scim_user: NotRequired[shared_scimuser.ScimUserTypedDict]
    r"""Successful"""


class PatchScimUsersResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    scim_user: Optional[shared_scimuser.ScimUser] = None
    r"""Successful"""
