"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingassociatedcontact import (
    AccountingAssociatedContact,
    AccountingAssociatedContactTypedDict,
)
from .accountingcontactpaymentmethod import (
    AccountingContactPaymentMethod,
    AccountingContactPaymentMethodTypedDict,
)
from .accountingemail import AccountingEmail, AccountingEmailTypedDict
from .accountingtelephone import AccountingTelephone, AccountingTelephoneTypedDict
from .property_accountingcontact_billing_address import (
    PropertyAccountingContactBillingAddress,
    PropertyAccountingContactBillingAddressTypedDict,
)
from .property_accountingcontact_shipping_address import (
    PropertyAccountingContactShippingAddress,
    PropertyAccountingContactShippingAddressTypedDict,
)
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class TaxExemption(str, Enum):
    FEDERAL_GOV = "FEDERAL_GOV"
    REGION_GOV = "REGION_GOV"
    LOCAL_GOV = "LOCAL_GOV"
    TRIBAL_GOV = "TRIBAL_GOV"
    CHARITABLE_ORG = "CHARITABLE_ORG"
    RELIGIOUS_ORG = "RELIGIOUS_ORG"
    EDUCATIONAL_ORG = "EDUCATIONAL_ORG"
    MEDICAL_ORG = "MEDICAL_ORG"
    RESALE = "RESALE"
    FOREIGN = "FOREIGN"
    OTHER = "OTHER"


class AccountingContactTypedDict(TypedDict):
    associated_contacts: NotRequired[List[AccountingAssociatedContactTypedDict]]
    billing_address: NotRequired[PropertyAccountingContactBillingAddressTypedDict]
    company_name: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    emails: NotRequired[List[AccountingEmailTypedDict]]
    id: NotRequired[str]
    identification: NotRequired[str]
    is_active: NotRequired[bool]
    is_customer: NotRequired[bool]
    is_supplier: NotRequired[bool]
    name: NotRequired[str]
    payment_methods: NotRequired[List[AccountingContactPaymentMethodTypedDict]]
    portal_url: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    shipping_address: NotRequired[PropertyAccountingContactShippingAddressTypedDict]
    tax_exemption: NotRequired[TaxExemption]
    tax_number: NotRequired[str]
    telephones: NotRequired[List[AccountingTelephoneTypedDict]]
    updated_at: NotRequired[datetime]


class AccountingContact(BaseModel):
    associated_contacts: Optional[List[AccountingAssociatedContact]] = None

    billing_address: Optional[PropertyAccountingContactBillingAddress] = None

    company_name: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = "USD"

    emails: Optional[List[AccountingEmail]] = None

    id: Optional[str] = None

    identification: Optional[str] = None

    is_active: Optional[bool] = None

    is_customer: Optional[bool] = None

    is_supplier: Optional[bool] = None

    name: Optional[str] = None

    payment_methods: Optional[List[AccountingContactPaymentMethod]] = None

    portal_url: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    shipping_address: Optional[PropertyAccountingContactShippingAddress] = None

    tax_exemption: Optional[TaxExemption] = None

    tax_number: Optional[str] = None

    telephones: Optional[List[AccountingTelephone]] = None

    updated_at: Optional[datetime] = None
