"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .property_crmevent_call import PropertyCrmEventCall, PropertyCrmEventCallTypedDict
from .property_crmevent_email import (
    PropertyCrmEventEmail,
    PropertyCrmEventEmailTypedDict,
)
from .property_crmevent_form import PropertyCrmEventForm, PropertyCrmEventFormTypedDict
from .property_crmevent_marketing_email import (
    PropertyCrmEventMarketingEmail,
    PropertyCrmEventMarketingEmailTypedDict,
)
from .property_crmevent_meeting import (
    PropertyCrmEventMeeting,
    PropertyCrmEventMeetingTypedDict,
)
from .property_crmevent_note import PropertyCrmEventNote, PropertyCrmEventNoteTypedDict
from .property_crmevent_page_view import (
    PropertyCrmEventPageView,
    PropertyCrmEventPageViewTypedDict,
)
from .property_crmevent_task import PropertyCrmEventTask, PropertyCrmEventTaskTypedDict
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class CrmEventType(str, Enum):
    NOTE = "NOTE"
    EMAIL = "EMAIL"
    TASK = "TASK"
    MEETING = "MEETING"
    CALL = "CALL"
    MARKETING_EMAIL = "MARKETING_EMAIL"
    FORM = "FORM"
    PAGE_VIEW = "PAGE_VIEW"


class CrmEventTypedDict(TypedDict):
    r"""An event represents an event, activity, or engagement and is always associated with a deal, contact, or company"""

    call: NotRequired[PropertyCrmEventCallTypedDict]
    r"""The call object, when type = call"""
    company_ids: NotRequired[List[str]]
    r"""An array of company IDs associated with this event"""
    contact_ids: NotRequired[List[str]]
    r"""An array of contact IDs associated with this event"""
    created_at: NotRequired[datetime]
    deal_ids: NotRequired[List[str]]
    r"""An array of deal IDs associated with this event"""
    email: NotRequired[PropertyCrmEventEmailTypedDict]
    r"""The email object, when type = email"""
    form: NotRequired[PropertyCrmEventFormTypedDict]
    id: NotRequired[str]
    lead_ids: NotRequired[List[str]]
    marketing_email: NotRequired[PropertyCrmEventMarketingEmailTypedDict]
    meeting: NotRequired[PropertyCrmEventMeetingTypedDict]
    r"""The meeting object, when type = meeting"""
    note: NotRequired[PropertyCrmEventNoteTypedDict]
    r"""The note object, when type = note"""
    page_view: NotRequired[PropertyCrmEventPageViewTypedDict]
    raw: NotRequired[Dict[str, Any]]
    task: NotRequired[PropertyCrmEventTaskTypedDict]
    r"""The task object, when type = task"""
    type: NotRequired[CrmEventType]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]


class CrmEvent(BaseModel):
    r"""An event represents an event, activity, or engagement and is always associated with a deal, contact, or company"""

    call: Optional[PropertyCrmEventCall] = None
    r"""The call object, when type = call"""

    company_ids: Optional[List[str]] = None
    r"""An array of company IDs associated with this event"""

    contact_ids: Optional[List[str]] = None
    r"""An array of contact IDs associated with this event"""

    created_at: Optional[datetime] = None

    deal_ids: Optional[List[str]] = None
    r"""An array of deal IDs associated with this event"""

    email: Optional[PropertyCrmEventEmail] = None
    r"""The email object, when type = email"""

    form: Optional[PropertyCrmEventForm] = None

    id: Optional[str] = None

    lead_ids: Optional[List[str]] = None

    marketing_email: Optional[PropertyCrmEventMarketingEmail] = None

    meeting: Optional[PropertyCrmEventMeeting] = None
    r"""The meeting object, when type = meeting"""

    note: Optional[PropertyCrmEventNote] = None
    r"""The note object, when type = note"""

    page_view: Optional[PropertyCrmEventPageView] = None

    raw: Optional[Dict[str, Any]] = None

    task: Optional[PropertyCrmEventTask] = None
    r"""The task object, when type = task"""

    type: Optional[CrmEventType] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None
