"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .enrichemail import EnrichEmail, EnrichEmailTypedDict
from .enrichpersonworkhistory import (
    EnrichPersonWorkHistory,
    EnrichPersonWorkHistoryTypedDict,
)
from .enrichtelephone import EnrichTelephone, EnrichTelephoneTypedDict
from .property_enrichperson_address import (
    PropertyEnrichPersonAddress,
    PropertyEnrichPersonAddressTypedDict,
)
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class Gender(str, Enum):
    MALE = "MALE"
    FEMALE = "FEMALE"


class EnrichPersonTypedDict(TypedDict):
    r"""A person object from an enrichment integration"""

    address: NotRequired[PropertyEnrichPersonAddressTypedDict]
    r"""The address of the person"""
    bio: NotRequired[str]
    birthdate: NotRequired[str]
    company: NotRequired[str]
    company_domain: NotRequired[str]
    created_at: NotRequired[datetime]
    emails: NotRequired[List[EnrichEmailTypedDict]]
    r"""An array of email addresses for this person"""
    facebook_url: NotRequired[str]
    gender: NotRequired[Gender]
    github_url: NotRequired[str]
    github_username: NotRequired[str]
    id: NotRequired[str]
    image_url: NotRequired[str]
    linkedin_url: NotRequired[str]
    name: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    r"""The raw data returned by the integration for this person"""
    telephones: NotRequired[List[EnrichTelephoneTypedDict]]
    r"""An array of telephones for this person"""
    timezone: NotRequired[str]
    title: NotRequired[str]
    twitter_handle: NotRequired[str]
    twitter_url: NotRequired[str]
    updated_at: NotRequired[datetime]
    utc_offset: NotRequired[float]
    work_histories: NotRequired[List[EnrichPersonWorkHistoryTypedDict]]


class EnrichPerson(BaseModel):
    r"""A person object from an enrichment integration"""

    address: Optional[PropertyEnrichPersonAddress] = None
    r"""The address of the person"""

    bio: Optional[str] = None

    birthdate: Optional[str] = None

    company: Optional[str] = None

    company_domain: Optional[str] = None

    created_at: Optional[datetime] = None

    emails: Optional[List[EnrichEmail]] = None
    r"""An array of email addresses for this person"""

    facebook_url: Optional[str] = None

    gender: Optional[Gender] = None

    github_url: Optional[str] = None

    github_username: Optional[str] = None

    id: Optional[str] = None

    image_url: Optional[str] = None

    linkedin_url: Optional[str] = None

    name: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None
    r"""The raw data returned by the integration for this person"""

    telephones: Optional[List[EnrichTelephone]] = None
    r"""An array of telephones for this person"""

    timezone: Optional[str] = None

    title: Optional[str] = None

    twitter_handle: Optional[str] = None

    twitter_url: Optional[str] = None

    updated_at: Optional[datetime] = None

    utc_offset: Optional[float] = None

    work_histories: Optional[List[EnrichPersonWorkHistory]] = None
