# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.7.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from localstack.sdk.models.action_and_resource import ActionAndResource
from localstack.sdk.models.check_actions_response_source_principal import CheckActionsResponseSourcePrincipal
from typing import Optional, Set
from typing_extensions import Self

class CheckActionsResponse(BaseModel):
    """
    actions check response
    """ # noqa: E501
    allowed: Optional[StrictBool] = Field(default=None, description="All of the actions in the request are allowed to be performed on the given resource")
    implicit_deny: Optional[List[ActionAndResource]] = Field(default=None, description="all actions from the request that resulted in an implicit deny")
    explicit_deny: Optional[List[ActionAndResource]] = Field(default=None, description="all actions from the request that resulted in an explicit deny")
    explicit_allow: Optional[List[ActionAndResource]] = Field(default=None, description="all actions from the request that explicitly allowed")
    source_principal: Optional[CheckActionsResponseSourcePrincipal] = None
    status_code: Optional[StrictInt] = Field(default=None, description="currently default values do not use for determining success or failures")
    status_reason: Optional[StrictStr] = Field(default=None, description="currently default values do not use for determining success or failures")
    __properties: ClassVar[List[str]] = ["allowed", "implicit_deny", "explicit_deny", "explicit_allow", "source_principal", "status_code", "status_reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckActionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in implicit_deny (list)
        _items = []
        if self.implicit_deny:
            for _item_implicit_deny in self.implicit_deny:
                if _item_implicit_deny:
                    _items.append(_item_implicit_deny.to_dict())
            _dict['implicit_deny'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in explicit_deny (list)
        _items = []
        if self.explicit_deny:
            for _item_explicit_deny in self.explicit_deny:
                if _item_explicit_deny:
                    _items.append(_item_explicit_deny.to_dict())
            _dict['explicit_deny'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in explicit_allow (list)
        _items = []
        if self.explicit_allow:
            for _item_explicit_allow in self.explicit_allow:
                if _item_explicit_allow:
                    _items.append(_item_explicit_allow.to_dict())
            _dict['explicit_allow'] = _items
        # override the default output from pydantic by calling `to_dict()` of source_principal
        if self.source_principal:
            _dict['source_principal'] = self.source_principal.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckActionsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowed": obj.get("allowed"),
            "implicit_deny": [ActionAndResource.from_dict(_item) for _item in obj["implicit_deny"]] if obj.get("implicit_deny") is not None else None,
            "explicit_deny": [ActionAndResource.from_dict(_item) for _item in obj["explicit_deny"]] if obj.get("explicit_deny") is not None else None,
            "explicit_allow": [ActionAndResource.from_dict(_item) for _item in obj["explicit_allow"]] if obj.get("explicit_allow") is not None else None,
            "source_principal": CheckActionsResponseSourcePrincipal.from_dict(obj["source_principal"]) if obj.get("source_principal") is not None else None,
            "status_code": obj.get("status_code"),
            "status_reason": obj.get("status_reason")
        })
        return _obj


