#-*- coding: utf-8 -*-
"""
Data for materials that are used in the construction of AguaClara water
treatment plants.
"""
from aguaclara.core.units import unit_registry as u

#:
PVC_PIPE_ROUGH = 0.12 * u.mm

#:
CONCRETE_PIPE_ROUGH = 2 * u.mm
#:
CONCRETE_DENSITY = 2400 * (u.kg / u.m ** 3)
#:
CONCRETE_THICKNESS_MIN = 5 * u.cm

#:
REBAR_D = 0.5 * u.inch
#:
ACRYLIC_T = 1 * u.cm
