import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::IAM::AccessKey`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html
 */
export interface CfnAccessKeyProps {
    /**
     * `AWS::IAM::AccessKey.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html#cfn-iam-accesskey-username
     */
    readonly userName: string;
    /**
     * `AWS::IAM::AccessKey.Serial`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html#cfn-iam-accesskey-serial
     */
    readonly serial?: number | cdk.Token;
    /**
     * `AWS::IAM::AccessKey.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html#cfn-iam-accesskey-status
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::IAM::AccessKey`
 *
 * @cloudformationResource AWS::IAM::AccessKey
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html
 */
export declare class CfnAccessKey extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::AccessKey";
    /**
     * @cloudformationAttribute SecretAccessKey
     */
    readonly accessKeySecretAccessKey: string;
    readonly accessKeyId: string;
    /**
     * Create a new `AWS::IAM::AccessKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessKeyProps);
    readonly propertyOverrides: CfnAccessKeyProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IAM::Group`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html
 */
export interface CfnGroupProps {
    /**
     * `AWS::IAM::Group.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html#cfn-iam-group-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::IAM::Group.ManagedPolicyArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html#cfn-iam-group-managepolicyarns
     */
    readonly managedPolicyArns?: string[];
    /**
     * `AWS::IAM::Group.Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html#cfn-iam-group-path
     */
    readonly path?: string;
    /**
     * `AWS::IAM::Group.Policies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html#cfn-iam-group-policies
     */
    readonly policies?: Array<CfnGroup.PolicyProperty | cdk.Token> | cdk.Token;
}
/**
 * A CloudFormation `AWS::IAM::Group`
 *
 * @cloudformationResource AWS::IAM::Group
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html
 */
export declare class CfnGroup extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::Group";
    /**
     * @cloudformationAttribute Arn
     */
    readonly groupArn: string;
    readonly groupName: string;
    /**
     * Create a new `AWS::IAM::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGroupProps);
    readonly propertyOverrides: CfnGroupProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    interface PolicyProperty {
        /**
         * `CfnGroup.PolicyProperty.PolicyDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        readonly policyDocument: object | cdk.Token;
        /**
         * `CfnGroup.PolicyProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        readonly policyName: string;
    }
}
/**
 * Properties for defining a `AWS::IAM::InstanceProfile`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html
 */
export interface CfnInstanceProfileProps {
    /**
     * `AWS::IAM::InstanceProfile.Roles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html#cfn-iam-instanceprofile-roles
     */
    readonly roles: string[];
    /**
     * `AWS::IAM::InstanceProfile.InstanceProfileName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html#cfn-iam-instanceprofile-instanceprofilename
     */
    readonly instanceProfileName?: string;
    /**
     * `AWS::IAM::InstanceProfile.Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html#cfn-iam-instanceprofile-path
     */
    readonly path?: string;
}
/**
 * A CloudFormation `AWS::IAM::InstanceProfile`
 *
 * @cloudformationResource AWS::IAM::InstanceProfile
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html
 */
export declare class CfnInstanceProfile extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::InstanceProfile";
    /**
     * @cloudformationAttribute Arn
     */
    readonly instanceProfileArn: string;
    readonly instanceProfileName: string;
    /**
     * Create a new `AWS::IAM::InstanceProfile`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInstanceProfileProps);
    readonly propertyOverrides: CfnInstanceProfileProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IAM::ManagedPolicy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html
 */
export interface CfnManagedPolicyProps {
    /**
     * `AWS::IAM::ManagedPolicy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-policydocument
     */
    readonly policyDocument: object | cdk.Token;
    /**
     * `AWS::IAM::ManagedPolicy.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-description
     */
    readonly description?: string;
    /**
     * `AWS::IAM::ManagedPolicy.Groups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-groups
     */
    readonly groups?: string[];
    /**
     * `AWS::IAM::ManagedPolicy.ManagedPolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-managedpolicyname
     */
    readonly managedPolicyName?: string;
    /**
     * `AWS::IAM::ManagedPolicy.Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-ec2-dhcpoptions-path
     */
    readonly path?: string;
    /**
     * `AWS::IAM::ManagedPolicy.Roles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-roles
     */
    readonly roles?: string[];
    /**
     * `AWS::IAM::ManagedPolicy.Users`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html#cfn-iam-managedpolicy-users
     */
    readonly users?: string[];
}
/**
 * A CloudFormation `AWS::IAM::ManagedPolicy`
 *
 * @cloudformationResource AWS::IAM::ManagedPolicy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-managedpolicy.html
 */
export declare class CfnManagedPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::ManagedPolicy";
    readonly managedPolicyArn: string;
    /**
     * Create a new `AWS::IAM::ManagedPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnManagedPolicyProps);
    readonly propertyOverrides: CfnManagedPolicyProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IAM::Policy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html
 */
export interface CfnPolicyProps {
    /**
     * `AWS::IAM::Policy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html#cfn-iam-policy-policydocument
     */
    readonly policyDocument: object | cdk.Token;
    /**
     * `AWS::IAM::Policy.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html#cfn-iam-policy-policyname
     */
    readonly policyName: string;
    /**
     * `AWS::IAM::Policy.Groups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html#cfn-iam-policy-groups
     */
    readonly groups?: string[];
    /**
     * `AWS::IAM::Policy.Roles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html#cfn-iam-policy-roles
     */
    readonly roles?: string[];
    /**
     * `AWS::IAM::Policy.Users`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html#cfn-iam-policy-users
     */
    readonly users?: string[];
}
/**
 * A CloudFormation `AWS::IAM::Policy`
 *
 * @cloudformationResource AWS::IAM::Policy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html
 */
export declare class CfnPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::Policy";
    readonly policyName: string;
    /**
     * Create a new `AWS::IAM::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyProps);
    readonly propertyOverrides: CfnPolicyProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IAM::Role`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html
 */
export interface CfnRoleProps {
    /**
     * `AWS::IAM::Role.AssumeRolePolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-assumerolepolicydocument
     */
    readonly assumeRolePolicyDocument: object | cdk.Token;
    /**
     * `AWS::IAM::Role.ManagedPolicyArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-managepolicyarns
     */
    readonly managedPolicyArns?: string[];
    /**
     * `AWS::IAM::Role.MaxSessionDuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-maxsessionduration
     */
    readonly maxSessionDuration?: number | cdk.Token;
    /**
     * `AWS::IAM::Role.Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-path
     */
    readonly path?: string;
    /**
     * `AWS::IAM::Role.PermissionsBoundary`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-permissionsboundary
     */
    readonly permissionsBoundary?: string;
    /**
     * `AWS::IAM::Role.Policies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-policies
     */
    readonly policies?: Array<CfnRole.PolicyProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::IAM::Role.RoleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#cfn-iam-role-rolename
     */
    readonly roleName?: string;
}
/**
 * A CloudFormation `AWS::IAM::Role`
 *
 * @cloudformationResource AWS::IAM::Role
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html
 */
export declare class CfnRole extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::Role";
    /**
     * @cloudformationAttribute Arn
     */
    readonly roleArn: string;
    /**
     * @cloudformationAttribute RoleId
     */
    readonly roleId: string;
    readonly roleName: string;
    /**
     * Create a new `AWS::IAM::Role`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRoleProps);
    readonly propertyOverrides: CfnRoleProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnRole {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    interface PolicyProperty {
        /**
         * `CfnRole.PolicyProperty.PolicyDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        readonly policyDocument: object | cdk.Token;
        /**
         * `CfnRole.PolicyProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        readonly policyName: string;
    }
}
/**
 * Properties for defining a `AWS::IAM::ServiceLinkedRole`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-servicelinkedrole.html
 */
export interface CfnServiceLinkedRoleProps {
    /**
     * `AWS::IAM::ServiceLinkedRole.AWSServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-servicelinkedrole.html#cfn-iam-servicelinkedrole-awsservicename
     */
    readonly awsServiceName: string;
    /**
     * `AWS::IAM::ServiceLinkedRole.CustomSuffix`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-servicelinkedrole.html#cfn-iam-servicelinkedrole-customsuffix
     */
    readonly customSuffix?: string;
    /**
     * `AWS::IAM::ServiceLinkedRole.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-servicelinkedrole.html#cfn-iam-servicelinkedrole-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::IAM::ServiceLinkedRole`
 *
 * @cloudformationResource AWS::IAM::ServiceLinkedRole
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-servicelinkedrole.html
 */
export declare class CfnServiceLinkedRole extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::ServiceLinkedRole";
    /**
     * Create a new `AWS::IAM::ServiceLinkedRole`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServiceLinkedRoleProps);
    readonly propertyOverrides: CfnServiceLinkedRoleProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IAM::User`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html
 */
export interface CfnUserProps {
    /**
     * `AWS::IAM::User.Groups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-groups
     */
    readonly groups?: string[];
    /**
     * `AWS::IAM::User.LoginProfile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-loginprofile
     */
    readonly loginProfile?: CfnUser.LoginProfileProperty | cdk.Token;
    /**
     * `AWS::IAM::User.ManagedPolicyArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-managepolicyarns
     */
    readonly managedPolicyArns?: string[];
    /**
     * `AWS::IAM::User.Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-path
     */
    readonly path?: string;
    /**
     * `AWS::IAM::User.PermissionsBoundary`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-permissionsboundary
     */
    readonly permissionsBoundary?: string;
    /**
     * `AWS::IAM::User.Policies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-policies
     */
    readonly policies?: Array<CfnUser.PolicyProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::IAM::User.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html#cfn-iam-user-username
     */
    readonly userName?: string;
}
/**
 * A CloudFormation `AWS::IAM::User`
 *
 * @cloudformationResource AWS::IAM::User
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html
 */
export declare class CfnUser extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::User";
    /**
     * @cloudformationAttribute Arn
     */
    readonly userArn: string;
    readonly userName: string;
    /**
     * Create a new `AWS::IAM::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnUserProps);
    readonly propertyOverrides: CfnUserProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnUser {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html
     */
    interface LoginProfileProperty {
        /**
         * `CfnUser.LoginProfileProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
         */
        readonly password: string;
        /**
         * `CfnUser.LoginProfileProperty.PasswordResetRequired`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
         */
        readonly passwordResetRequired?: boolean | cdk.Token;
    }
}
export declare namespace CfnUser {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    interface PolicyProperty {
        /**
         * `CfnUser.PolicyProperty.PolicyDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        readonly policyDocument: object | cdk.Token;
        /**
         * `CfnUser.PolicyProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        readonly policyName: string;
    }
}
/**
 * Properties for defining a `AWS::IAM::UserToGroupAddition`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html
 */
export interface CfnUserToGroupAdditionProps {
    /**
     * `AWS::IAM::UserToGroupAddition.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html#cfn-iam-addusertogroup-groupname
     */
    readonly groupName: string;
    /**
     * `AWS::IAM::UserToGroupAddition.Users`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html#cfn-iam-addusertogroup-users
     */
    readonly users: string[];
}
/**
 * A CloudFormation `AWS::IAM::UserToGroupAddition`
 *
 * @cloudformationResource AWS::IAM::UserToGroupAddition
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html
 */
export declare class CfnUserToGroupAddition extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::IAM::UserToGroupAddition";
    /**
     * Create a new `AWS::IAM::UserToGroupAddition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserToGroupAdditionProps);
    readonly propertyOverrides: CfnUserToGroupAdditionProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
