import cdk = require('@aws-cdk/cdk');
import { PolicyStatement, PrincipalPolicyFragment } from './policy-document';
import { IPrincipal } from './principals';
/**
 * Properties for an ImportedResourcePrincipal
 */
export interface ImportedResourcePrincipalProps {
    /**
     * The resource the role proxy is for
     */
    readonly resource: cdk.IConstruct;
}
/**
 * A principal associated with an imported resource
 *
 * Some resources have roles associated with them which they assume, such as
 * Lambda Functions, CodeBuild projects, StepFunctions machines, etc.
 *
 * When those resources are imported, their actual roles are not always
 * imported with them. When that happens, we use an instance of this class
 * instead, which will add user warnings when statements are attempted to be
 * added to it.
 */
export declare class ImportedResourcePrincipal implements IPrincipal {
    readonly assumeRoleAction: string;
    readonly grantPrincipal: IPrincipal;
    private readonly resource;
    constructor(props: ImportedResourcePrincipalProps);
    readonly policyFragment: PrincipalPolicyFragment;
    addToPolicy(statement: PolicyStatement): boolean;
}
