"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A principal associated with an imported resource
 *
 * Some resources have roles associated with them which they assume, such as
 * Lambda Functions, CodeBuild projects, StepFunctions machines, etc.
 *
 * When those resources are imported, their actual roles are not always
 * imported with them. When that happens, we use an instance of this class
 * instead, which will add user warnings when statements are attempted to be
 * added to it.
 */
class ImportedResourcePrincipal {
    constructor(props) {
        this.assumeRoleAction = 'sts:AssumeRole';
        this.resource = props.resource;
        this.grantPrincipal = this;
    }
    get policyFragment() {
        throw new Error(`Cannot get policy fragment of ${this.resource.node.path}, resource imported without a role`);
    }
    addToPolicy(statement) {
        const repr = JSON.stringify(this.resource.node.resolve(statement));
        this.resource.node.addWarning(`Add statement to this resource's role: ${repr}`);
        return true; // Pretend we did the work. The human will do it for us, eventually.
    }
}
exports.ImportedResourcePrincipal = ImportedResourcePrincipal;
//# sourceMappingURL=data:application/json;base64,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