import cdk = require('@aws-cdk/cdk');
import { Grant } from './grant';
import { Policy } from './policy';
import { PolicyStatement, PrincipalPolicyFragment } from './policy-document';
import { IPrincipal } from './principals';
import { IRole, RoleProps } from './role';
export interface LazyRoleProps extends RoleProps {
}
/**
 * An IAM role that only gets attached to the construct tree once it gets used, not before
 *
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 */
export declare class LazyRole extends cdk.Construct implements IRole {
    private readonly props;
    readonly grantPrincipal: IPrincipal;
    readonly assumeRoleAction: string;
    private role?;
    private readonly statements;
    private readonly policies;
    private readonly managedPolicies;
    constructor(scope: cdk.Construct, id: string, props: LazyRoleProps);
    /**
     * Adds a permission to the role's default policy document.
     * If there is no default policy attached to this role, it will be created.
     * @param statement The permission statement to add to the policy document
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * Attaches a policy to this role.
     * @param policy The policy to attach
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * Attaches a managed policy to this role.
     * @param arn The ARN of the managed policy to attach.
     */
    attachManagedPolicy(arn: string): void;
    /**
     * Returns the ARN of this role.
     */
    readonly roleArn: string;
    readonly roleId: string;
    readonly roleName: string;
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     */
    grant(identity: IPrincipal, ...actions: string[]): Grant;
    /**
     * Grant permissions to the given principal to pass this role.
     */
    grantPassRole(identity: IPrincipal): Grant;
    private instantiate;
}
