"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class ExampleConstruct extends cdk.Construct {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const user = new lib_1.User(this, 'MyUser', { password: cdk_1.SecretValue.plainText('1234') });
        const group = new lib_1.Group(this, 'MyGroup');
        const policy = new lib_1.Policy(this, 'MyPolicy');
        policy.attachToUser(user);
        group.attachInlinePolicy(policy);
        /// !hide
    }
}
exports.ExampleConstruct = ExampleConstruct;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5hdHRhY2hpbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5hdHRhY2hpbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsb0NBQXFDO0FBQ3JDLHNDQUEyQztBQUMzQyxnQ0FBNkM7QUFFN0MsTUFBYSxnQkFBaUIsU0FBUSxHQUFHLENBQUMsU0FBUztJQUNqRCxZQUFZLEtBQW9CLEVBQUUsRUFBVTtRQUMxQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLFNBQVM7UUFDVCxNQUFNLElBQUksR0FBRyxJQUFJLFVBQUksQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLEVBQUUsUUFBUSxFQUFFLGlCQUFXLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUNuRixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFekMsTUFBTSxNQUFNLEdBQUcsSUFBSSxZQUFNLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQzVDLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDMUIsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pDLFNBQVM7SUFDWCxDQUFDO0NBQ0Y7QUFiRCw0Q0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jZGsnKTtcbmltcG9ydCB7IFNlY3JldFZhbHVlIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IEdyb3VwLCBQb2xpY3ksIFVzZXIgfSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgY2xhc3MgRXhhbXBsZUNvbnN0cnVjdCBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLy8gIXNob3dcbiAgICBjb25zdCB1c2VyID0gbmV3IFVzZXIodGhpcywgJ015VXNlcicsIHsgcGFzc3dvcmQ6IFNlY3JldFZhbHVlLnBsYWluVGV4dCgnMTIzNCcpIH0pO1xuICAgIGNvbnN0IGdyb3VwID0gbmV3IEdyb3VwKHRoaXMsICdNeUdyb3VwJyk7XG5cbiAgICBjb25zdCBwb2xpY3kgPSBuZXcgUG9saWN5KHRoaXMsICdNeVBvbGljeScpO1xuICAgIHBvbGljeS5hdHRhY2hUb1VzZXIodXNlcik7XG4gICAgZ3JvdXAuYXR0YWNoSW5saW5lUG9saWN5KHBvbGljeSk7XG4gICAgLy8vICFoaWRlXG4gIH1cbn0iXX0=