"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const user_1 = require("../lib/user");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'aws-cdk-iam-policy');
const user = new user_1.User(stack, 'MyUser');
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatement(new lib_1.PolicyStatement().addResource('*').addAction('sqs:SendMessage'));
policy.attachToUser(user);
const policy2 = new lib_1.Policy(stack, 'GoodbyePolicy');
policy2.addStatement(new lib_1.PolicyStatement().addResource('*').addAction('lambda:InvokeFunction'));
policy2.attachToUser(user);
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcucG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQTBDO0FBQzFDLGdDQUFpRDtBQUNqRCxzQ0FBbUM7QUFFbkMsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFHLEVBQUUsQ0FBQztBQUV0QixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxHQUFHLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztBQUVuRCxNQUFNLElBQUksR0FBRyxJQUFJLFdBQUksQ0FBQyxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFFdkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxZQUFNLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRSxFQUFFLFVBQVUsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO0FBQzNFLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxxQkFBZSxFQUFFLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7QUFDekYsTUFBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUUxQixNQUFNLE9BQU8sR0FBRyxJQUFJLFlBQU0sQ0FBQyxLQUFLLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFDbkQsT0FBTyxDQUFDLFlBQVksQ0FBQyxJQUFJLHFCQUFlLEVBQUUsQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLENBQUMsU0FBUyxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztBQUNoRyxPQUFPLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBRTNCLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tIFwiQGF3cy1jZGsvY2RrXCI7XG5pbXBvcnQgeyBQb2xpY3ksIFBvbGljeVN0YXRlbWVudCB9IGZyb20gXCIuLi9saWJcIjtcbmltcG9ydCB7IFVzZXIgfSBmcm9tIFwiLi4vbGliL3VzZXJcIjtcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdhd3MtY2RrLWlhbS1wb2xpY3knKTtcblxuY29uc3QgdXNlciA9IG5ldyBVc2VyKHN0YWNrLCAnTXlVc2VyJyk7XG5cbmNvbnN0IHBvbGljeSA9IG5ldyBQb2xpY3koc3RhY2ssICdIZWxsb1BvbGljeScsIHsgcG9saWN5TmFtZTogJ0RlZmF1bHQnIH0pO1xucG9saWN5LmFkZFN0YXRlbWVudChuZXcgUG9saWN5U3RhdGVtZW50KCkuYWRkUmVzb3VyY2UoJyonKS5hZGRBY3Rpb24oJ3NxczpTZW5kTWVzc2FnZScpKTtcbnBvbGljeS5hdHRhY2hUb1VzZXIodXNlcik7XG5cbmNvbnN0IHBvbGljeTIgPSBuZXcgUG9saWN5KHN0YWNrLCAnR29vZGJ5ZVBvbGljeScpO1xucG9saWN5Mi5hZGRTdGF0ZW1lbnQobmV3IFBvbGljeVN0YXRlbWVudCgpLmFkZFJlc291cmNlKCcqJykuYWRkQWN0aW9uKCdsYW1iZGE6SW52b2tlRnVuY3Rpb24nKSk7XG5wb2xpY3kyLmF0dGFjaFRvVXNlcih1c2VyKTtcblxuYXBwLnJ1bigpO1xuIl19