"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'integ-iam-role-1');
const role = new lib_1.Role(stack, 'TestRole', {
    assumedBy: new lib_1.ServicePrincipal('sqs.amazonaws.com')
});
role.addToPolicy(new lib_1.PolicyStatement().addResource('*').addAction('sqs:SendMessage'));
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatement(new lib_1.PolicyStatement().addAction('ec2:*').addResource('*'));
policy.attachToRole(role);
// Role with an external ID
new lib_1.Role(stack, 'TestRole2', {
    assumedBy: new lib_1.AccountRootPrincipal(),
    externalId: 'supply-me',
});
app.run();
//# sourceMappingURL=data:application/json;base64,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