"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'integ-iam-role-1');
const g1 = new lib_1.Group(stack, 'MyGroup');
const g2 = new lib_1.Group(stack, 'YourGroup');
for (let i = 0; i < 5; ++i) {
    const user = new lib_1.User(stack, `User${i + 1}`);
    user.addToGroup(g1);
    g2.addUser(user);
}
const policy = new lib_1.Policy(stack, 'MyPolicy');
policy.attachToGroup(g1);
policy.addStatement(new lib_1.PolicyStatement().addResource(g2.groupArn).addAction('iam:*'));
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlcnMtYW5kLWdyb3Vwcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnVzZXJzLWFuZC1ncm91cHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzQ0FBMEM7QUFDMUMsZ0NBQThEO0FBRTlELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBRyxFQUFFLENBQUM7QUFFdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFLLENBQUMsR0FBRyxFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFFakQsTUFBTSxFQUFFLEdBQUcsSUFBSSxXQUFLLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBQ3ZDLE1BQU0sRUFBRSxHQUFHLElBQUksV0FBSyxDQUFDLEtBQUssRUFBRSxXQUFXLENBQUMsQ0FBQztBQUV6QyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFO0lBQzFCLE1BQU0sSUFBSSxHQUFHLElBQUksVUFBSSxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQzdDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDcEIsRUFBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztDQUNsQjtBQUVELE1BQU0sTUFBTSxHQUFHLElBQUksWUFBTSxDQUFDLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztBQUM3QyxNQUFNLENBQUMsYUFBYSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ3pCLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxxQkFBZSxFQUFFLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztBQUV2RixHQUFHLENBQUMsR0FBRyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSBcIkBhd3MtY2RrL2Nka1wiO1xuaW1wb3J0IHsgR3JvdXAsIFBvbGljeSwgUG9saWN5U3RhdGVtZW50LCBVc2VyIH0gZnJvbSBcIi4uL2xpYlwiO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ2ludGVnLWlhbS1yb2xlLTEnKTtcblxuY29uc3QgZzEgPSBuZXcgR3JvdXAoc3RhY2ssICdNeUdyb3VwJyk7XG5jb25zdCBnMiA9IG5ldyBHcm91cChzdGFjaywgJ1lvdXJHcm91cCcpO1xuXG5mb3IgKGxldCBpID0gMDsgaSA8IDU7ICsraSkge1xuICBjb25zdCB1c2VyID0gbmV3IFVzZXIoc3RhY2ssIGBVc2VyJHtpICsgMX1gKTtcbiAgdXNlci5hZGRUb0dyb3VwKGcxKTtcbiAgZzIuYWRkVXNlcih1c2VyKTtcbn1cblxuY29uc3QgcG9saWN5ID0gbmV3IFBvbGljeShzdGFjaywgJ015UG9saWN5Jyk7XG5wb2xpY3kuYXR0YWNoVG9Hcm91cChnMSk7XG5wb2xpY3kuYWRkU3RhdGVtZW50KG5ldyBQb2xpY3lTdGF0ZW1lbnQoKS5hZGRSZXNvdXJjZShnMi5ncm91cEFybikuYWRkQWN0aW9uKCdpYW06KicpKTtcblxuYXBwLnJ1bigpO1xuIl19