"use strict";
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'simple managed policy'(test) {
        const stack = new cdk.Stack();
        const mp = new lib_1.AwsManagedPolicy("service-role/SomePolicy", stack);
        test.deepEqual(stack.node.resolve(mp.policyArn), {
            "Fn::Join": ['', [
                    'arn:',
                    { Ref: 'AWS::Partition' },
                    ':iam::aws:policy/service-role/SomePolicy'
                ]]
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5tYW5hZ2VkLXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QubWFuYWdlZC1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9DQUFxQztBQUVyQyxnQ0FBMEM7QUFFMUMsaUJBQVM7SUFDUCx1QkFBdUIsQ0FBQyxJQUFVO1FBQ2hDLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzlCLE1BQU0sRUFBRSxHQUFHLElBQUksc0JBQWdCLENBQUMseUJBQXlCLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLEVBQUU7WUFDL0MsVUFBVSxFQUFFLENBQUMsRUFBRSxFQUFFO29CQUNmLE1BQU07b0JBQ04sRUFBRSxHQUFHLEVBQUUsZ0JBQWdCLEVBQUU7b0JBQ3pCLDBDQUEwQztpQkFDM0MsQ0FBQztTQUNILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGNkayA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2NkaycpO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCB7IEF3c01hbmFnZWRQb2xpY3kgfSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgPSB7XG4gICdzaW1wbGUgbWFuYWdlZCBwb2xpY3knKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcbiAgICBjb25zdCBtcCA9IG5ldyBBd3NNYW5hZ2VkUG9saWN5KFwic2VydmljZS1yb2xlL1NvbWVQb2xpY3lcIiwgc3RhY2spO1xuXG4gICAgdGVzdC5kZWVwRXF1YWwoc3RhY2subm9kZS5yZXNvbHZlKG1wLnBvbGljeUFybiksIHtcbiAgICAgIFwiRm46OkpvaW5cIjogWycnLCBbXG4gICAgICAgICdhcm46JyxcbiAgICAgICAgeyBSZWY6ICdBV1M6OlBhcnRpdGlvbicgfSxcbiAgICAgICAgJzppYW06OmF3czpwb2xpY3kvc2VydmljZS1yb2xlL1NvbWVQb2xpY3knXG4gICAgICBdXVxuICAgIH0pO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59O1xuIl19