# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_dict.ipynb.

# %% auto 0
__all__ = ['getfields', 'deconstruct', 'lookup', 'merge', 'take', 'filtkeys', 'takekeys', 'keepkeys', 'drop', 'dropkeys',
           'dictvals2tup', 'setdefaults']

# %% ../nbs/03_dict.ipynb 6
from dataclasses import fields
from functools import wraps

# %% ../nbs/03_dict.ipynb 8
#| export


# %% ../nbs/03_dict.ipynb 10
#| export


# %% ../nbs/03_dict.ipynb 12
from atyp import ListQ
from chck import isnone, isdict

# %% ../nbs/03_dict.ipynb 14
from .call import getcallattrs

# %% ../nbs/03_dict.ipynb 16
def getfields(inst, ignore: ListQ = None) -> dict:
    '''Get all `dataclass` `fields` of an instance as a dictionary'''
    ignore = ignore or []
    return {f.name: getattr(inst, f.name) for f in fields(inst) if f.name not in ignore}

# %% ../nbs/03_dict.ipynb 17
def deconstruct(d: dict, *args, __fallback = None) -> tuple:
    '''Deconstruct a dictionary
    
    Examples
    --------
    >>> b, d = deconstruct(dict(a=1, b=2, c=3, d=4), 'b', 'd')
    >>> b, d
    (2, 4)
    '''
    if isnone(__fallback): __fallback = tuple(None for _ in range(len(args)))
    return tuple(d.get(attr, default) for attr, default in zip(args, __fallback))

# %% ../nbs/03_dict.ipynb 18
def lookup(d: dict, __key: str, __default = None):
    return d.get(__key, __default)

def merge(*dicts: tuple[dict, ...]) -> dict:
    merged = {}
    for d in dicts: merged.update(d)
    return merged

# %% ../nbs/03_dict.ipynb 19
def take(d: dict, keys: list | dict) -> dict:
    keys = keys or []
    if isdict(keys): keys = keys.keys()
    return {k: d.get(k, None) for k in keys if k in d}

@wraps(take)
def filtkeys(d: dict, keys: list | dict) -> dict: 
    return take(d, keys)

@wraps(take)
def takekeys(d: dict, keys: list | dict) -> dict: return take(d, keys)

@wraps(take)
def keepkeys(d: dict, keys: list | dict) -> dict: return take(d, keys)

# %% ../nbs/03_dict.ipynb 20
def drop(d: dict, keys: list | dict = None) -> dict:
    keys = keys or []
    if isdict(keys): keys = keys.keys()
    return {k: d.get(k, None) for k in d.keys() if k not in keys}

@wraps(drop)
def dropkeys(d: dict, keys: list | dict) -> dict: return drop(d, keys)

# %% ../nbs/03_dict.ipynb 21
def dictvals2tup(d: dict, keys: list | dict = None) -> tuple:    
    return tuple((d if isnone(keys) else take(d, keys)).values())

# %% ../nbs/03_dict.ipynb 22
def setdefaults(d: dict, *attrs: str, **kwargs) -> dict:
    if bool(attrs) == False: attrs = list(kwargs.keys())
    called = getcallattrs(*attrs, **kwargs)
    for a, v in called.items(): d.setdefault(a, v)
    return d
