# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_time.ipynb.

# %% auto 0
__all__ = ['now', 'date', 'year', 'month', 'day', 'hour', 'min', 'ms', 'today', 'hrsmin', 'clock']

# %% ../nbs/00_time.ipynb 6
from datetime import date, datetime
from functools import wraps

# %% ../nbs/00_time.ipynb 8
#| export


# %% ../nbs/00_time.ipynb 10
#| export


# %% ../nbs/00_time.ipynb 12
from nchr import CLN, DASH, SPACE
from pfmt import fmt0str

# %% ../nbs/00_time.ipynb 14
#| export


# %% ../nbs/00_time.ipynb 16
@wraps(datetime.now)
def now(tz = None) -> datetime: return datetime.now(tz)

def date()   -> date: return now().date()
def year()   -> int: return now().year
def month()  -> int: return now().month
def day()    -> int: return now().day
def hour()   -> int: return now().hour
def min()    -> int: return now().minute
def ms()     -> int: return now().microsecond

# %% ../nbs/00_time.ipynb 17
def today(sep: str = DASH) -> str:
    y = fmt0str(year(), 4)
    m = fmt0str(month())
    d = fmt0str(day())
    return sep.join((d, m, y))

def hrsmin(sep: str = CLN) -> str:    
    h = fmt0str(hour())
    m = fmt0str(min())
    return sep.join((h, m))

def clock(sep: str = SPACE): 
    return sep.join((today(DASH), hrsmin(CLN)))
