"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCredentialsStackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxapi = require("@aws-cdk/cx-api");
const token_1 = require("../token");
const _asset_manifest_builder_1 = require("./_asset-manifest-builder");
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
const stack_synthesizer_1 = require("./stack-synthesizer");
/**
 * A synthesizer that uses conventional asset locations, but not conventional deployment roles
 *
 * Instead of assuming the bootstrapped deployment roles, all stack operations will be performed
 * using the CLI's current credentials.
 *
 * - This synthesizer does not support deploying to accounts to which the CLI does not have
 *   credentials. It also does not support deploying using **CDK Pipelines**. For either of those
 *   features, use `DefaultStackSynthesizer`.
 * - This synthesizer requires an S3 bucket and ECR repository with well-known names. To
 *   not depend on those, use `LegacyStackSynthesizer`.
 *
 * Be aware that your CLI credentials must be valid for the duration of the
 * entire deployment. If you are using session credentials, make sure the
 * session lifetime is long enough.
 *
 * By default, expects the environment to have been bootstrapped with just the staging resources
 * of the Bootstrap Stack V2 (also known as "modern bootstrap stack"). You can override
 * the default names using the synthesizer's construction properties.
 */
class CliCredentialsStackSynthesizer extends stack_synthesizer_1.StackSynthesizer {
    constructor(props = {}) {
        super();
        this.props = props;
        this.assetManifest = new _asset_manifest_builder_1.AssetManifestBuilder();
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CliCredentialsStackSynthesizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CliCredentialsStackSynthesizer);
            }
            throw error;
        }
        for (const key in props) {
            if (props.hasOwnProperty(key)) {
                validateNoToken(key);
            }
        }
        function validateNoToken(key) {
            const prop = props[key];
            if (typeof prop === 'string' && token_1.Token.isUnresolved(prop)) {
                throw new Error(`DefaultSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: ` + [
                    '${Qualifier}',
                    cxapi.EnvironmentPlaceholders.CURRENT_REGION,
                    cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT,
                    cxapi.EnvironmentPlaceholders.CURRENT_PARTITION,
                ].join(', '));
            }
        }
    }
    bind(stack) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.stack !== undefined) {
            throw new Error('A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack');
        }
        this.stack = stack;
        const qualifier = this.props.qualifier ?? stack.node.tryGetContext(default_synthesizer_1.BOOTSTRAP_QUALIFIER_CONTEXT) ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_QUALIFIER;
        this.qualifier = qualifier;
        const spec = new _shared_1.StringSpecializer(stack, qualifier);
        /* eslint-disable max-len */
        this.bucketName = spec.specialize(this.props.fileAssetsBucketName ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME);
        this.repositoryName = spec.specialize(this.props.imageAssetsRepositoryName ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME);
        this.bucketPrefix = spec.specialize(this.props.bucketPrefix ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX);
        this.dockerTagPrefix = spec.specialize(this.props.dockerTagPrefix ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX);
    }
    addFileAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_FileAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addFileAsset);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.bucketName);
        _shared_1.assertBound(this.bucketPrefix);
        return this.assetManifest.addFileAssetDefault(asset, this.stack, this.bucketName, this.bucketPrefix);
    }
    addDockerImageAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_DockerImageAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDockerImageAsset);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.repositoryName);
        _shared_1.assertBound(this.dockerTagPrefix);
        return this.assetManifest.addDockerImageAssetDefault(asset, this.stack, this.repositoryName, this.dockerTagPrefix);
    }
    /**
     * Synthesize the associated stack to the session
     */
    synthesize(session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesize);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.qualifier);
        this.synthesizeStackTemplate(this.stack, session);
        const templateAsset = this.addFileAsset(_shared_1.stackTemplateFileAsset(this.stack, session));
        const assetManifestId = this.assetManifest.writeManifest(this.stack, session);
        this.emitStackArtifact(this.stack, session, {
            stackTemplateAssetObjectUrl: templateAsset.s3ObjectUrlWithPlaceholders,
            additionalDependencies: [assetManifestId],
        });
    }
}
exports.CliCredentialsStackSynthesizer = CliCredentialsStackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
CliCredentialsStackSynthesizer[_a] = { fqn: "@aws-cdk/core.CliCredentialsStackSynthesizer", version: "1.167.0" };
//# sourceMappingURL=data:application/json;base64,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