/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QueryReader {
    public static final int DEFAULT_START_INDEX = 1;
    private static final int NO_INDEX = -1;
    private int _curIndex;

    public QueryReader() {
        this(1);
    }

    public QueryReader(int startIndex) {
        if (startIndex < 1) {
            throw new IllegalArgumentException("invalid start index");
        }
        this._curIndex = startIndex;
    }

    public Column getNewColumn() {
        return new Column(this);
    }

    public static class Column
    extends SqlObject {
        private QueryReader _outer;
        private int _index = -1;
        private SqlObject _columnObj;

        public Column(QueryReader outer) {
            this._outer = outer;
        }

        public Column setColumnObject(com.healthmarketscience.sqlbuilder.dbspec.Column columnObj) {
            return this.setCustomColumnObject(columnObj);
        }

        public Column setCustomColumnObject(Object columnObj) {
            this._columnObj = Converter.toColumnSqlObject(columnObj);
            return this;
        }

        public SqlObject getCustomColumnObject() {
            return this._columnObj;
        }

        public boolean isInQuery() {
            return this.getIndex() != -1;
        }

        private void setIndex(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        protected void addIndex(int index) {
            if (this.getIndex() != -1) {
                throw new IllegalStateException("attempt to reset value of Column, cannot reuse or use multiple times in the same query");
            }
            this.setIndex(index);
        }

        public int getInt(ResultSet rs) throws SQLException {
            return rs.getInt(this.getIndex());
        }

        public long getLong(ResultSet rs) throws SQLException {
            return rs.getLong(this.getIndex());
        }

        public boolean getBoolean(ResultSet rs) throws SQLException {
            return rs.getBoolean(this.getIndex());
        }

        public String getString(ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                return rs.getString(this.getIndex());
            }
            return null;
        }

        public Object getObject(ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                return rs.getObject(this.getIndex());
            }
            return null;
        }

        public void updateNull(ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                rs.updateNull(this.getIndex());
            }
        }

        public void updateInt(int value, ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                rs.updateInt(this.getIndex(), value);
            }
        }

        public void updateInt(Integer value, ResultSet rs) throws SQLException {
            if (value != null) {
                this.updateInt((int)value, rs);
            } else {
                this.updateNull(rs);
            }
        }

        public void updateLong(long value, ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                rs.updateLong(this.getIndex(), value);
            }
        }

        public void updateLong(Long value, ResultSet rs) throws SQLException {
            if (value != null) {
                this.updateLong((long)value, rs);
            } else {
                this.updateNull(rs);
            }
        }

        public void updateBoolean(boolean value, ResultSet rs) throws SQLException {
            if (this.isInQuery()) {
                rs.updateBoolean(this.getIndex(), value);
            }
        }

        public void updateBoolean(Boolean value, ResultSet rs) throws SQLException {
            if (value != null) {
                this.updateBoolean((boolean)value, rs);
            } else {
                this.updateNull(rs);
            }
        }

        public void updateString(String value, ResultSet rs) throws SQLException {
            if (value != null) {
                if (this.isInQuery()) {
                    rs.updateString(this.getIndex(), value);
                }
            } else {
                this.updateNull(rs);
            }
        }

        public void updateObject(Object value, ResultSet rs) throws SQLException {
            if (value != null) {
                if (this.isInQuery()) {
                    rs.updateObject(this.getIndex(), value);
                }
            } else {
                this.updateNull(rs);
            }
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._columnObj.collectSchemaObjects(vContext);
        }

        public final void appendTo(AppendableExt app) throws IOException {
            this.addIndex(this._outer._curIndex++);
            app.append(this._columnObj);
        }
    }
}

