/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbCheckConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbFunction;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbFunctionPackage;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbIndex;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbJoin;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSpec {
    public static final String DEFAULT_ALIAS_PREFIX = "t";
    private final String _aliasPrefix;
    private final List<DbSchema> _schemas = new ArrayList<DbSchema>();
    private final List<DbJoin> _joins = new ArrayList<DbJoin>();
    private int _nextAliasNum;

    public DbSpec() {
        this(DEFAULT_ALIAS_PREFIX);
    }

    public DbSpec(String aliasPrefix) {
        this._aliasPrefix = aliasPrefix;
    }

    public List<DbSchema> getSchemas() {
        return this._schemas;
    }

    public List<DbJoin> getJoins() {
        return this._joins;
    }

    public String getNextAlias() {
        return this._aliasPrefix + this._nextAliasNum++;
    }

    public DbSchema getDefaultSchema() {
        return this.findSchema(null);
    }

    public DbSchema findSchema(String name) {
        return DbObject.findObject(this._schemas, name);
    }

    public DbSchema addDefaultSchema() {
        return this.addSchema((String)null);
    }

    public DbSchema addSchema(String name) {
        DbSchema schema = this.createSchema(name);
        return this.addSchema(schema);
    }

    public <T extends DbSchema> T addSchema(T schema) {
        this._schemas.add(this.checkOwnership(schema));
        return schema;
    }

    public DbJoin addJoin(String schemaFrom, String tableFrom, String schemaTo, String tableTo, String ... colNames) {
        return this.addJoin(schemaFrom, tableFrom, schemaTo, tableTo, colNames, colNames);
    }

    public DbJoin addJoin(String schemaFrom, String tableFrom, String schemaTo, String tableTo, String[] fromColNames, String[] toColNames) {
        DbJoin join = this.createJoin(this.findSchema(schemaFrom).findTable(tableFrom), this.findSchema(schemaTo).findTable(tableTo), fromColNames, toColNames);
        return this.addJoin(join);
    }

    public <T extends DbJoin> T addJoin(T join) {
        this._joins.add(this.checkOwnership(join));
        return join;
    }

    public DbSchema createSchema(String name) {
        return new DbSchema(this, name);
    }

    public DbTable createTable(DbSchema parent, String name) {
        return new DbTable(parent, name);
    }

    public DbColumn createColumn(DbTable parent, String name, String typeName, Object ... typeQualifiers) {
        return new DbColumn(parent, name, typeName, typeQualifiers);
    }

    public DbJoin createJoin(DbTable fromTable, DbTable toTable, String[] fromColNames, String[] toColNames) {
        return new DbJoin(this, fromTable, toTable, fromColNames, toColNames);
    }

    public DbIndex createIndex(DbTable table, String name, String ... colNames) {
        return new DbIndex(table, name, colNames);
    }

    public DbFunctionPackage createFunctionPackage(DbSchema parent, String name) {
        return new DbFunctionPackage(parent, name);
    }

    public DbFunction createFunction(DbFunctionPackage parent, String name) {
        return new DbFunction(parent, name);
    }

    public DbConstraint createColumnConstraint(DbColumn parent, String name, Constraint.Type type) {
        return new DbConstraint(parent, name, type);
    }

    public DbConstraint createTableConstraint(DbTable parent, String name, Constraint.Type type, String ... colNames) {
        return new DbConstraint(parent, name, type, colNames);
    }

    @Deprecated
    public DbForeignKeyConstraint createColumnForeignKeyConstraint(DbColumn parent, String name, DbTable referencedTable, String refColName) {
        return this.createColumnForeignKeyConstraint(parent, name, referencedTable, referencedTable.findColumn(refColName));
    }

    public DbForeignKeyConstraint createColumnForeignKeyConstraint(DbColumn parent, String name, DbTable referencedTable, DbColumn referencedColumn) {
        return new DbForeignKeyConstraint(parent, name, referencedTable, referencedColumn);
    }

    @Deprecated
    public DbForeignKeyConstraint createTableForeignKeyConstraint(DbTable parent, String name, DbTable referencedTable, String[] colNames, String[] refColNames) {
        return this.createTableForeignKeyConstraint(parent, name, referencedTable, parent.findColumns(colNames), referencedTable.findColumns(refColNames));
    }

    public DbForeignKeyConstraint createTableForeignKeyConstraint(DbTable parent, String name, DbTable referencedTable, DbColumn[] columns, DbColumn[] refColumns) {
        return new DbForeignKeyConstraint(parent, name, referencedTable, columns, refColumns);
    }

    public DbCheckConstraint createColumnCheckConstraint(DbColumn parent, String name, Condition condition) {
        return new DbCheckConstraint(parent, name, condition);
    }

    public DbCheckConstraint createTableCheckConstraint(DbTable parent, String name, Condition condition) {
        return new DbCheckConstraint(parent, name, condition);
    }

    protected <T extends DbObject<?>> T checkOwnership(T obj) {
        if (obj.getSpec() != this) {
            throw new IllegalArgumentException("Given " + obj.getClass().getSimpleName() + " is not owned by this " + this.getClass().getSimpleName());
        }
        return obj;
    }
}

