/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.maxlikelihood;

import org.linqs.psl.util.Logger;
import org.linqs.psl.util.RandUtils;

public class SimplexSampler {
    private Logger log = Logger.getLogger(SimplexSampler.class);

    public double[] getNext(int d) {
        int i;
        double[] x = new double[d];
        double sum = 0.0;
        for (i = 0; i < d; ++i) {
            x[i] = -Math.log(RandUtils.nextDouble());
            sum += x[i];
        }
        if (sum == Double.POSITIVE_INFINITY) {
            sum = 0.0;
            for (i = 0; i < d; ++i) {
                if (x[i] == Double.POSITIVE_INFINITY) {
                    x[i] = 1.0;
                    sum += 1.0;
                    continue;
                }
                x[i] = 0.0;
            }
            i = 0;
            while (i < d) {
                int n = i++;
                x[n] = x[n] / sum;
            }
        } else {
            i = 0;
            while (i < d) {
                int n = i++;
                x[n] = x[n] / sum;
            }
        }
        return x;
    }

    public static void main(String[] args) {
        SimplexSampler sampler = new SimplexSampler();
        for (int d = 1; d <= 3; ++d) {
            for (int i = 0; i < 1000; ++i) {
                double[] x = sampler.getNext(d);
                for (int j = 0; j < d; ++j) {
                    System.out.print("" + x[j] + "\t");
                }
                System.out.println();
            }
        }
    }
}

