/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.linqs.psl.application.inference.online.messages.responses.OnlineResponse;
import org.linqs.psl.cli.CommandLineLoader;
import org.linqs.psl.cli.OnlineActionInterface;
import org.linqs.psl.config.RuntimeOptions;
import org.linqs.psl.runtime.Runtime;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Logger;

public class Launcher {
    private static final Logger log = Logger.getLogger(Launcher.class);
    private CommandLine parsedOptions;

    private Launcher(CommandLine givenOptions) {
        this.parsedOptions = givenOptions;
    }

    private void outputServerResponses(List<OnlineResponse> serverResponses) {
        for (OnlineResponse response : serverResponses) {
            System.out.println(response.toString());
        }
    }

    private void outputServerResponses(List<OnlineResponse> serverResponses, String outputFilePath) {
        Path outputDirectory = Paths.get(outputFilePath, new String[0]).getParent();
        if (outputDirectory != null) {
            FileUtils.mkdir(outputDirectory.toString());
        }
        try (BufferedWriter bufferedWriter = FileUtils.getBufferedWriter(outputFilePath);){
            for (OnlineResponse response : serverResponses) {
                bufferedWriter.write(response.toString() + "\n");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Error writing online server responses to file: %s", outputFilePath), ex);
        }
    }

    private void runOnlineClient() {
        log.info("Starting OnlinePSL client.");
        List<OnlineResponse> serverResponses = OnlineActionInterface.run();
        log.info("OnlinePSL client closed.");
        if (!this.parsedOptions.hasOption("onlineServerOutput")) {
            log.trace("Writing server responses to stdout.");
            this.outputServerResponses(serverResponses);
        } else {
            String outputFilePath = this.parsedOptions.getOptionValue("onlineServerOutput");
            log.trace("Writing inferred predicates to file: " + outputFilePath);
            this.outputServerResponses(serverResponses, outputFilePath);
        }
    }

    private void convertRuntimeOptions() {
        String path;
        Properties props;
        String method;
        boolean hasInference = false;
        boolean hasLearn = false;
        if (this.parsedOptions.hasOption("i")) {
            hasInference = true;
            RuntimeOptions.INFERENCE.set(true);
            method = this.parsedOptions.getOptionValue("i");
            if (method != null) {
                RuntimeOptions.INFERENCE_METHOD.set(method);
            }
        }
        if (this.parsedOptions.hasOption("l")) {
            hasLearn = true;
            RuntimeOptions.LEARN.set(true);
            method = this.parsedOptions.getOptionValue("l");
            if (method != null) {
                RuntimeOptions.LEARN_METHOD.set(method);
            }
        }
        if (!hasInference && !hasLearn) {
            RuntimeOptions.INFERENCE.set(true);
        }
        if (this.parsedOptions.hasOption("d")) {
            RuntimeOptions.INFERENCE_DATA_PATH.set(this.parsedOptions.getOptionValue("d"));
            RuntimeOptions.LEARN_DATA_PATH.set(this.parsedOptions.getOptionValue("d"));
        }
        if (this.parsedOptions.hasOption("m")) {
            String modelPath = this.parsedOptions.getOptionValue("m");
            RuntimeOptions.INFERENCE_MODEL_PATH.set(modelPath);
            RuntimeOptions.LEARN_MODEL_PATH.set(modelPath);
            RuntimeOptions.LEARN_OUTPUT_MODEL_PATH.set(modelPath.replaceFirst("\\.psl$", "-learned.psl"));
        }
        if (this.parsedOptions.hasOption("h2path")) {
            RuntimeOptions.DB_H2.set(true);
            RuntimeOptions.DB_H2_PATH.set(this.parsedOptions.getOptionValue("h2path"));
        }
        if (this.parsedOptions.hasOption("postgres")) {
            RuntimeOptions.DB_PG.set(true);
            RuntimeOptions.DB_PG_NAME.set(this.parsedOptions.getOptionValue("postgres"));
        }
        if (this.parsedOptions.hasOption("e")) {
            ArrayList<String> evaluatorNames = new ArrayList<String>();
            for (String evaluatorName : this.parsedOptions.getOptionValues("e")) {
                evaluatorNames.add(evaluatorName);
            }
            RuntimeOptions.INFERENCE_EVAL.set(ListUtils.join(",", evaluatorNames));
        }
        if (this.parsedOptions.hasOption("int")) {
            RuntimeOptions.DB_INT_IDS.set(this.parsedOptions.hasOption("int"));
        }
        if (this.parsedOptions.hasOption("D") && (props = this.parsedOptions.getOptionProperties("D")).containsKey("log4j.threshold")) {
            RuntimeOptions.LOG_LEVEL.set(props.getProperty("log4j.threshold"));
        }
        if (this.parsedOptions.hasOption("o")) {
            RuntimeOptions.INFERENCE_OUTPUT_RESULTS_DIR.set(this.parsedOptions.getOptionValue("o"));
        }
        if (this.parsedOptions.hasOption("groundrules")) {
            RuntimeOptions.INFERENCE_OUTPUT_GROUNDRULES.set(true);
            path = this.parsedOptions.getOptionValue("groundrules");
            if (path != null) {
                RuntimeOptions.INFERENCE_OUTPUT_GROUNDRULES_PATH.set(path);
            }
        }
        if (this.parsedOptions.hasOption("satisfaction")) {
            RuntimeOptions.INFERENCE_OUTPUT_SATISFACTIONS.set(true);
            path = this.parsedOptions.getOptionValue("satisfaction");
            if (path != null) {
                RuntimeOptions.INFERENCE_OUTPUT_SATISFACTIONS_PATH.set(path);
            }
        }
        if (this.parsedOptions.hasOption("p")) {
            RuntimeOptions.PROPERTIES_PATH.set(this.parsedOptions.getOptionValue("p"));
        }
        if (this.parsedOptions.hasOption("skipAtomCommit")) {
            RuntimeOptions.INFERENCE_COMMIT.set(!this.parsedOptions.hasOption("skipAtomCommit"));
        }
    }

    private void run() {
        if (this.parsedOptions.hasOption("onlineClient")) {
            this.runOnlineClient();
            return;
        }
        this.convertRuntimeOptions();
        Runtime runtime = new Runtime();
        runtime.run();
    }

    private static boolean isCommandLineValid(CommandLine givenOptions) {
        if (givenOptions.hasOption("h") || givenOptions.hasOption("v")) {
            return false;
        }
        if (givenOptions.hasOption("onlineClient")) {
            return true;
        }
        HelpFormatter helpFormatter = new HelpFormatter();
        if (!givenOptions.hasOption("d")) {
            System.out.println(String.format("Missing required option: --%s/-%s.", "data", "d"));
            helpFormatter.printHelp("psl", CommandLineLoader.getOptions(), true);
            return false;
        }
        if (!givenOptions.hasOption("m")) {
            System.out.println(String.format("Missing required option: --%s/-%s.", "model", "m"));
            helpFormatter.printHelp("psl", CommandLineLoader.getOptions(), true);
            return false;
        }
        if (!givenOptions.hasOption("i") && !givenOptions.hasOption("l")) {
            System.out.println(String.format("Missing required option: --%s/-%s.", "infer", "i"));
            helpFormatter.printHelp("psl", CommandLineLoader.getOptions(), true);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Launcher.main(args, false);
    }

    public static void main(String[] args, boolean rethrow) {
        try {
            CommandLineLoader commandLineLoader = new CommandLineLoader(args);
            CommandLine givenOptions = commandLineLoader.getParsedOptions();
            if (givenOptions == null || !Launcher.isCommandLineValid(givenOptions)) {
                return;
            }
            Launcher pslLauncher = new Launcher(givenOptions);
            pslLauncher.run();
        }
        catch (Exception ex) {
            if (rethrow) {
                throw new RuntimeException("Failed to run CLI: " + ex.getMessage(), ex);
            }
            System.err.println("Unexpected exception!");
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

