/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.linqs.psl.application.inference.online.OnlineClient;
import org.linqs.psl.application.inference.online.messages.OnlineMessage;
import org.linqs.psl.application.inference.online.messages.actions.controls.Exit;
import org.linqs.psl.application.inference.online.messages.responses.OnlineResponse;
import org.linqs.psl.parser.OnlineActionLoader;
import org.linqs.psl.util.FileUtils;

public class OnlineActionInterface {
    public static List<OnlineResponse> run() {
        ArrayList<OnlineResponse> serverResponses = new ArrayList<OnlineResponse>();
        CountDownLatch modelRegistrationLatch = new CountDownLatch(1);
        try (BufferedReader commandReader = FileUtils.getBufferedReader(System.in);){
            String userInput = null;
            OnlineMessage onlineAction = null;
            LinkedBlockingQueue<OnlineMessage> onlineActions = new LinkedBlockingQueue<OnlineMessage>();
            OnlineClient onlineClient = new OnlineClient(onlineActions, serverResponses, modelRegistrationLatch);
            Thread onlineClientThread = new Thread(onlineClient);
            onlineClientThread.start();
            modelRegistrationLatch.await();
            while (!(onlineAction instanceof Exit)) {
                try {
                    userInput = commandReader.readLine();
                    if (userInput == null) break;
                    if (userInput.trim().equals("")) continue;
                    onlineAction = OnlineActionLoader.loadAction(userInput);
                    onlineActions.add(onlineAction);
                }
                catch (InputMismatchException | ParseCancellationException ex) {
                    System.out.printf("Error parsing command: [%s].%n", userInput);
                    System.out.printf("Caused by: %s.%n", ex.getMessage());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            onlineClientThread.join();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return serverResponses;
    }
}

