/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.SelectivityHistogram;
import org.linqs.psl.database.rdbms.TableStats;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.Logger;

public class QueryRewriter {
    private static final Logger log = Logger.getLogger(QueryRewriter.class);
    private double allowedTotalCostIncrease = Options.QR_ALLOWED_TOTAL_INCREASE.getDouble();
    private double allowedStepCostIncrease = Options.QR_ALLOWED_STEP_INCREASE.getDouble();
    private CostEstimator costEstimator = CostEstimator.valueOf(Options.QR_COST_ESTIMATOR.getString().toUpperCase());

    public Formula rewrite(Formula baseFormula, RDBMSDataStore dataStore) {
        double baseCost;
        DatabaseQuery.validate(baseFormula);
        if (baseFormula instanceof Atom) {
            return baseFormula;
        }
        Set<Atom> usedAtoms = baseFormula.getAtoms(new HashSet<Atom>());
        Set<Atom> passthrough = this.filterBaseAtoms(usedAtoms);
        Map<Predicate, TableStats> tableStats = this.fetchTableStats(usedAtoms, dataStore);
        double currentCost = baseCost = this.estimateQuerySize(this.costEstimator, usedAtoms, null, tableStats, dataStore);
        log.trace("Starting cost: " + baseCost);
        while (true) {
            double bestCost = -1.0;
            Atom bestAtom = null;
            for (Atom atom : usedAtoms) {
                if (!this.canRemove(atom, usedAtoms)) continue;
                double cost = this.estimateQuerySize(this.costEstimator, usedAtoms, atom, tableStats, dataStore);
                if (cost < 0.0) {
                    log.trace("Planned Cost for (" + usedAtoms + " - " + atom + "): MAX");
                    continue;
                }
                log.trace("Planned Cost for (" + usedAtoms + " - " + atom + "): " + cost);
                if (bestAtom != null && !(cost < bestCost)) continue;
                bestAtom = atom;
                bestCost = cost;
            }
            if (bestAtom == null || bestCost > baseCost * this.allowedTotalCostIncrease || bestCost > currentCost * this.allowedStepCostIncrease) break;
            usedAtoms.remove(bestAtom);
            currentCost = bestCost;
            log.trace("Choose plan for iteration: " + usedAtoms + ": " + bestCost);
        }
        usedAtoms.addAll(passthrough);
        Formula query = null;
        query = usedAtoms.size() == 1 ? (Formula)usedAtoms.iterator().next() : new Conjunction(usedAtoms.toArray(new Formula[0]));
        log.debug("Computed cost-based query rewrite for [{}]({}): [{}]({}).", baseFormula, baseCost, query, currentCost);
        return query;
    }

    private double estimateQuerySize(CostEstimator costEstimator, Set<Atom> atoms, Atom ignore, Map<Predicate, TableStats> tableStats, RDBMSDataStore dataStore) {
        if (costEstimator == CostEstimator.HISTOGRAM) {
            return this.estimateQuerySizeWithHistorgram(atoms, ignore, tableStats, dataStore);
        }
        if (costEstimator == CostEstimator.SELECTIVITY) {
            return this.estimateQuerySizeWithSelectivity(atoms, ignore, tableStats, dataStore);
        }
        if (costEstimator == CostEstimator.SIZE) {
            return this.estimateQuerySizeWithSize(atoms, ignore, tableStats, dataStore);
        }
        throw new IllegalStateException("Unknown CostEstimator value: " + (Object)((Object)costEstimator));
    }

    private double estimateQuerySizeWithHistorgram(Set<Atom> atoms, Atom ignore, Map<Predicate, TableStats> tableStats, RDBMSDataStore dataStore) {
        double cost = 1.0;
        for (Atom atom : atoms) {
            if (atom == ignore) continue;
            cost *= (double)tableStats.get(atom.getPredicate()).getCount();
        }
        for (Map.Entry entry : this.getAllUsedVariables(atoms, null).entrySet()) {
            Variable variable = (Variable)entry.getKey();
            Set involvedAtoms = (Set)entry.getValue();
            if (involvedAtoms.size() <= 1) continue;
            SelectivityHistogram joinHistogram = null;
            double crossProductSize = 1.0;
            for (Atom atom : involvedAtoms) {
                SelectivityHistogram ignoreUnchecked;
                if (atom == ignore) continue;
                crossProductSize *= (double)tableStats.get(atom.getPredicate()).getCount();
                String columnName = this.getColumnName(dataStore, atom, variable);
                SelectivityHistogram histogram = tableStats.get(atom.getPredicate()).getHistogram(columnName);
                if (joinHistogram == null) {
                    joinHistogram = histogram;
                    continue;
                }
                joinHistogram = ignoreUnchecked = joinHistogram.join(histogram);
            }
            long joinSize = joinHistogram.size();
            if (joinSize == Long.MAX_VALUE) {
                return -1.0;
            }
            cost *= (double)joinHistogram.size() / crossProductSize;
        }
        return cost;
    }

    private double estimateQuerySizeWithSelectivity(Set<Atom> atoms, Atom ignore, Map<Predicate, TableStats> tableStats, RDBMSDataStore dataStore) {
        double cost = 1.0;
        for (Atom atom : atoms) {
            if (atom == ignore) continue;
            cost *= (double)tableStats.get(atom.getPredicate()).getCount();
        }
        for (Variable variable : this.getAllUsedVariables(atoms, null).keySet()) {
            int cardinalitiesCount = 0;
            int minCardinality = 0;
            for (Atom atom : atoms) {
                if (atom == ignore || !atom.getVariables().contains(variable)) continue;
                String columnName = this.getColumnName(dataStore, atom, variable);
                int cardinality = tableStats.get(atom.getPredicate()).getCardinality(columnName);
                if (cardinalitiesCount == 0 || cardinality < minCardinality) {
                    minCardinality = cardinality;
                }
                ++cardinalitiesCount;
            }
            if (cardinalitiesCount <= 1) continue;
            cost /= (double)minCardinality;
        }
        return cost;
    }

    private double estimateQuerySizeWithSize(Set<Atom> atoms, Atom ignore, Map<Predicate, TableStats> tableStats, RDBMSDataStore dataStore) {
        double cost = 1.0;
        for (Atom atom : atoms) {
            if (atom == ignore) continue;
            cost *= (double)tableStats.get(atom.getPredicate()).getCount();
        }
        return cost;
    }

    private String getColumnName(RDBMSDataStore dataStore, Atom atom, Variable variable) {
        int columnIndex = -1;
        Term[] args = atom.getArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!variable.equals(args[i])) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new NoSuchElementException(String.format("Could not find column name for variable %s in atom %s.", variable, atom));
        }
        return dataStore.getPredicateInfo(atom.getPredicate()).argumentColumns().get(columnIndex);
    }

    private boolean canRemove(Atom atom, Set<Atom> usedAtoms) {
        Set<Variable> remainingVariables = atom.getVariables();
        remainingVariables.removeAll(this.getAllUsedVariables(usedAtoms, atom).keySet());
        return remainingVariables.size() == 0;
    }

    private Map<Variable, Set<Atom>> getAllUsedVariables(Set<Atom> atoms, Atom ignore) {
        HashMap<Variable, Set<Atom>> variables = new HashMap<Variable, Set<Atom>>();
        for (Atom atom : atoms) {
            if (atom == ignore) continue;
            for (Variable variable : atom.getVariables()) {
                if (!variables.containsKey(variable)) {
                    variables.put(variable, new HashSet());
                }
                ((Set)variables.get(variable)).add(atom);
            }
        }
        return variables;
    }

    private Map<Predicate, TableStats> fetchTableStats(Set<Atom> usedAtoms, RDBMSDataStore dataStore) {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        for (Atom atom : usedAtoms) {
            predicates.add(atom.getPredicate());
        }
        HashMap<Predicate, TableStats> stats = new HashMap<Predicate, TableStats>();
        for (Predicate predicate : predicates) {
            stats.put(predicate, dataStore.getPredicateInfo(predicate).getTableStats(dataStore.getDriver()));
        }
        return stats;
    }

    private Set<Atom> filterBaseAtoms(Set<Atom> atoms) {
        HashSet<Atom> passthrough = new HashSet<Atom>();
        HashSet<Atom> removeAtoms = new HashSet<Atom>();
        for (Atom atom : atoms) {
            if (atom.getPredicate() instanceof ExternalFunctionalPredicate) {
                removeAtoms.add(atom);
                continue;
            }
            if (atom.getPredicate() instanceof GroundingOnlyPredicate) {
                removeAtoms.add(atom);
                passthrough.add(atom);
                continue;
            }
            if (atom.getPredicate() instanceof StandardPredicate) continue;
            throw new IllegalStateException("Unknown predicate type: " + atom.getPredicate().getClass().getName());
        }
        atoms.removeAll(removeAtoms);
        return passthrough;
    }

    public static enum CostEstimator {
        SIZE,
        SELECTIVITY,
        HISTOGRAM;

    }
}

