/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.database.rdbms.SelectivityHistogram;

public class TableStats {
    private int count;
    private Map<String, Double> selectivity;
    private Map<String, SelectivityHistogram> histograms;

    public TableStats(int count) {
        this.count = count;
        this.selectivity = new HashMap<String, Double>();
        this.histograms = new HashMap<String, SelectivityHistogram>();
    }

    public void addColumnSelectivity(String column, double columnSelectivity) {
        column = column.toUpperCase();
        this.selectivity.put(column, columnSelectivity);
    }

    public void addColumnHistogram(String column, SelectivityHistogram histogram) {
        column = column.toUpperCase();
        this.histograms.put(column, histogram);
    }

    public int getCount() {
        return this.count;
    }

    public SelectivityHistogram getHistogram(String column) {
        column = column.toUpperCase();
        return this.histograms.get(column);
    }

    public double getSelectivity(String column) {
        return this.selectivity.get(column.toUpperCase());
    }

    public int getCardinality(String column) {
        return (int)(this.selectivity.get(column.toUpperCase()) * (double)this.count);
    }
}

