/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.TableStats;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseDriver {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDriver.class);
    protected final HikariDataSource dataSource;

    public DatabaseDriver(String driverClass, String connectionString, boolean clearDatabase) {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not find database driver (" + driverClass + "). Please check classpath.", ex);
        }
        log.debug("Connecting to database using driver: " + driverClass);
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(connectionString);
        config.setMaximumPoolSize(Math.max(8, Parallel.getNumThreads() * 2));
        config.setMaxLifetime(0L);
        this.dataSource = new HikariDataSource(config);
        if (clearDatabase) {
            this.clearDatabase();
        }
    }

    public void close() {
        this.dataSource.close();
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get connection from pool.", ex);
        }
    }

    public boolean supportsBulkCopy() {
        return false;
    }

    public void bulkCopy(String path, String delimiter, boolean hasTruth, PredicateInfo predicateInfo, Partition partition) {
        throw new UnsupportedOperationException(this.getClass() + " does not support bulk copy.");
    }

    protected abstract void clearDatabase();

    public abstract String getTypeName(ConstantType var1);

    public abstract String getSurrogateKeyColumnDefinition(String var1);

    public abstract String getDoubleTypeName();

    public String finalizeCreateTable(CreateTableQuery createTable) {
        return ((CreateTableQuery)createTable.validate()).toString();
    }

    public abstract String getUpsert(String var1, String[] var2, String[] var3);

    public abstract String getStringAggregate(String var1, String var2, boolean var3);

    public abstract TableStats getTableStats(PredicateInfo var1);

    public abstract void updateDBStats();

    public abstract void updateTableStats(PredicateInfo var1);

    public ExplainResult explain(String queryString) {
        throw new UnsupportedOperationException(this.getClass() + " does not support EXPLAIN.");
    }

    public static class ExplainResult {
        public final double totalCost;
        public final double startupCost;
        public final long rows;

        public ExplainResult(double totalCost, double startupCost, long rows) {
            this.startupCost = startupCost;
            this.totalCost = totalCost;
            this.rows = rows;
        }

        public String toString() {
            return String.format("Rows: %d, Total Cost: %f, Startup Cost: %f", this.rows, this.totalCost, this.startupCost);
        }
    }
}

