/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.TableStats;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class H2DatabaseDriver
extends DatabaseDriver {
    private static final Logger log = Logger.getLogger(H2DatabaseDriver.class);

    public H2DatabaseDriver(Type dbType, String path, boolean clearDatabase) {
        super("org.h2.Driver", H2DatabaseDriver.buildConnectionString(dbType, path), clearDatabase);
        log.debug("Connected to H2 database: " + path);
    }

    private static String buildConnectionString(Type dbType, String path) {
        switch (dbType) {
            case Disk: {
                return "jdbc:h2:" + path;
            }
            case Memory: {
                return "jdbc:h2:mem:" + path;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + (Object)((Object)dbType));
    }

    @Override
    protected void clearDatabase() {
        this.executeUpdate("DROP ALL OBJECTS");
    }

    private void executeUpdate(String sql) {
        try (Connection connection = this.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to execute a general update: [" + sql + "].", ex);
        }
    }

    @Override
    public String getTypeName(ConstantType type) {
        switch (type) {
            case Double: {
                return "DOUBLE";
            }
            case Integer: {
                return "INT";
            }
            case String: {
                return "VARCHAR";
            }
            case Long: {
                return "BIGINT";
            }
            case UniqueIntID: {
                return "INT";
            }
            case UniqueStringID: {
                return "VARCHAR(255)";
            }
        }
        throw new IllegalStateException("Unknown ConstantType: " + (Object)((Object)type));
    }

    @Override
    public String getSurrogateKeyColumnDefinition(String columnName) {
        return columnName + " BIGINT IDENTITY PRIMARY KEY";
    }

    @Override
    public String getDoubleTypeName() {
        return "DOUBLE";
    }

    @Override
    public String getUpsert(String tableName, String[] columns, String[] keyColumns) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("MERGE INTO " + tableName + "");
        sql.add("    (" + StringUtils.join(", ", (Object[])columns) + ")");
        sql.add("KEY");
        sql.add("    (" + StringUtils.join(", ", (Object[])keyColumns) + ")");
        sql.add("VALUES");
        sql.add("    (" + StringUtils.repeat("?", ", ", columns.length) + ")");
        return ListUtils.join(System.lineSeparator(), sql);
    }

    @Override
    public String getStringAggregate(String columnName, String delimiter, boolean distinct) {
        if (delimiter.contains("'")) {
            throw new IllegalArgumentException("Delimiter (" + delimiter + ") may not contain a single quote.");
        }
        return String.format("GROUP_CONCAT(DISTINCT CAST(%s AS TEXT) SEPARATOR '%s')", columnName, delimiter);
    }

    @Override
    public TableStats getTableStats(PredicateInfo predicate) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("SELECT");
        sql.add("    UPPER(COLUMN_NAME) AS col,");
        sql.add("    (SELECT COUNT(*) FROM " + predicate.tableName() + ") AS tableCount,");
        sql.add("    SELECTIVITY / 100.0 AS selectivity");
        sql.add("FROM INFORMATION_SCHEMA.COLUMNS");
        sql.add("WHERE");
        sql.add("    UPPER(TABLE_NAME) = '" + predicate.tableName().toUpperCase() + "'");
        sql.add("    AND UPPER(COLUMN_NAME) NOT IN ('PARTITION_ID', 'VALUE')");
        TableStats stats = null;
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join(System.lineSeparator(), sql));
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                if (stats == null) {
                    stats = new TableStats(result.getInt(2));
                }
                stats.addColumnSelectivity(result.getString(1), result.getDouble(3));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get stats from table: " + predicate.tableName(), ex);
        }
        return stats;
    }

    @Override
    public void updateDBStats() {
        this.executeUpdate("ANALYZE");
    }

    @Override
    public void updateTableStats(PredicateInfo predicate) {
    }

    public static enum Type {
        Disk,
        Memory;

    }
}

