/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.database.rdbms.driver.PostgreSQLDriver;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.grounding.collective.CandidateGeneration;
import org.linqs.psl.grounding.collective.CandidateQuery;
import org.linqs.psl.grounding.collective.Coverage;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Parallel;

public class Grounding {
    private static final Logger log = Logger.getLogger(Grounding.class);

    private Grounding() {
    }

    public static long groundAll(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        boolean collective = Options.GROUNDING_COLLECTIVE.getBoolean();
        if (collective) {
            return Grounding.groundCollective(rules, atomManager, groundRuleStore);
        }
        return Grounding.groundIndependent(rules, atomManager, groundRuleStore);
    }

    private static long groundIndependent(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        long groundCount = 0L;
        for (Rule rule : rules) {
            groundCount += rule.groundAll(atomManager, groundRuleStore);
        }
        return groundCount;
    }

    private static long groundCollective(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        ArrayList<Rule> bypassRules = new ArrayList<Rule>();
        ArrayList<Rule> collectiveRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule.supportsGroundingQueryRewriting()) {
                collectiveRules.add(rule);
                continue;
            }
            bypassRules.add(rule);
        }
        Set<CandidateQuery> candidates = Grounding.genCandidates(collectiveRules, atomManager.getDatabase());
        Set<CandidateQuery> coverage = Coverage.compute(collectiveRules, candidates);
        long initialSize = groundRuleStore.size();
        Grounding.groundIndependent(bypassRules, atomManager, groundRuleStore);
        int batchSize = Options.GROUNDING_COLLECTIVE_BATCH_SIZE.getInt();
        for (CandidateQuery candidate : coverage) {
            HashSet<Rule> toGround = new HashSet<Rule>(collectiveRules);
            toGround.retainAll(candidate.getCoveredRules());
            Grounding.sharedGrounding(candidate, toGround, atomManager, groundRuleStore, batchSize);
            collectiveRules.removeAll(candidate.getCoveredRules());
        }
        return groundRuleStore.size() - initialSize;
    }

    private static Set<CandidateQuery> genCandidates(List<Rule> collectiveRules, Database database) {
        CandidateGeneration candidateGeneration;
        Set<CandidateQuery> candidates = Collections.synchronizedSet(new HashSet());
        if (!(database instanceof RDBMSDatabase) || !(((RDBMSDataStore)database.getDataStore()).getDriver() instanceof PostgreSQLDriver)) {
            log.warn("Cannot generate query candidates without a PostgreSQL database, grounding will be suboptimal.");
            candidateGeneration = null;
        } else {
            candidateGeneration = new CandidateGeneration();
        }
        if (candidateGeneration == null) {
            for (Rule rule : collectiveRules) {
                candidates.add(new CandidateQuery(rule, rule.getRewritableGroundingFormula(), 0.0));
            }
            return candidates;
        }
        final int candiatesPerRule = Options.GROUNDING_COLLECTIVE_CANDIDATE_COUNT.getInt();
        final RDBMSDatabase finalDatabase = (RDBMSDatabase)database;
        final Set<CandidateQuery> finalCandidates = candidates;
        log.debug("Generating candidates.");
        Parallel.RunTimings timings = Parallel.foreach(collectiveRules, new Parallel.Worker<Rule>(){

            @Override
            public void work(long index, Rule rule) {
                candidateGeneration.generateCandidates(rule, finalDatabase, candiatesPerRule, finalCandidates);
            }
        });
        log.debug("Generated {} candidates", candidates.size());
        log.trace("    " + timings);
        return candidates;
    }

    private static long sharedGrounding(CandidateQuery candidate, Set<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore, int batchSize) {
        log.debug("Grounding {} rule(s) with query: [{}].", rules.size(), candidate.getFormula());
        for (Rule rule : rules) {
            log.trace("    " + rule);
        }
        boolean oldAccessExceptionState = atomManager.enableAccessExceptions(false);
        QueryResultIterable queryResults = atomManager.executeGroundingQuery(candidate.getFormula());
        HashMap<Rule, Map<Variable, Integer>> variableMaps = new HashMap<Rule, Map<Variable, Integer>>();
        Map<Variable, Integer> baseVariableMap = queryResults.getVariableMap();
        for (Rule rule : rules) {
            if (rule == candidate.getBaseRule()) {
                variableMaps.put(rule, baseVariableMap);
                continue;
            }
            HashMap<Variable, Integer> variableMap = new HashMap<Variable, Integer>();
            Map<Variable, Variable> containmentMapping = candidate.getVariableMapping(rule);
            for (Map.Entry<Variable, Integer> baseVariabelMapEntry : baseVariableMap.entrySet()) {
                variableMap.put(containmentMapping.get(baseVariabelMapEntry.getKey()), baseVariabelMapEntry.getValue());
            }
            variableMaps.put(rule, variableMap);
        }
        long initialCount = groundRuleStore.size();
        Parallel.RunTimings timings = Parallel.foreachBatch(queryResults, batchSize, new GroundWorker(atomManager, groundRuleStore, variableMaps, rules));
        long groundCount = groundRuleStore.size() - initialCount;
        atomManager.enableAccessExceptions(oldAccessExceptionState);
        log.debug("Generated {} ground rules from {} query results.", groundCount, timings.iterations);
        log.trace("   " + timings);
        return groundCount;
    }

    private static class GroundWorker
    extends Parallel.Worker<List<Constant[]>> {
        private AtomManager atomManager;
        private GroundRuleStore groundRuleStore;
        private Map<Rule, Map<Variable, Integer>> variableMaps;
        private Set<Rule> rules;
        private List<GroundRule> groundRules;

        public GroundWorker(AtomManager atomManager, GroundRuleStore groundRuleStore, Map<Rule, Map<Variable, Integer>> variableMaps, Set<Rule> rules) {
            this.atomManager = atomManager;
            this.groundRuleStore = groundRuleStore;
            this.variableMaps = variableMaps;
            this.rules = rules;
            this.groundRules = new ArrayList<GroundRule>();
        }

        public Object clone() {
            return new GroundWorker(this.atomManager, this.groundRuleStore, this.variableMaps, this.rules);
        }

        @Override
        public void work(long size, List<Constant[]> batch) {
            GroundRule groundRule = null;
            for (Rule rule : this.rules) {
                int rowIndex = 0;
                while ((long)rowIndex < size) {
                    rule.ground(batch.get(rowIndex), this.variableMaps.get(rule), this.atomManager, this.groundRules);
                    for (int groundRuleIndex = 0; groundRuleIndex < this.groundRules.size(); ++groundRuleIndex) {
                        groundRule = this.groundRules.get(groundRuleIndex);
                        if (groundRule == null) continue;
                        this.groundRuleStore.addGroundRule(groundRule);
                    }
                    this.groundRules.clear();
                    ++rowIndex;
                }
            }
        }
    }
}

