/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding;

import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.Logger;

public class PartialGrounding {
    private static final Logger log = Logger.getLogger(PartialGrounding.class);

    private PartialGrounding() {
    }

    public static Set<StandardPredicate> getPartialPredicates(Set<? extends GroundAtom> atoms) {
        HashSet<StandardPredicate> partialPredicates = new HashSet<StandardPredicate>();
        for (GroundAtom groundAtom : atoms) {
            if (!(groundAtom.getPredicate() instanceof StandardPredicate)) continue;
            partialPredicates.add((StandardPredicate)groundAtom.getPredicate());
        }
        return partialPredicates;
    }

    public static Set<Rule> getPartialRules(List<Rule> rules, Set<StandardPredicate> partialPredicates) {
        HashSet<Rule> partialRules = new HashSet<Rule>();
        block0: for (Rule rule : rules) {
            if (rule instanceof AbstractLogicalRule) {
                for (Atom atom : ((AbstractLogicalRule)rule).getNegatedDNF().getQueryFormula().getAtoms(new HashSet<Atom>())) {
                    if (!partialPredicates.contains(atom.getPredicate())) continue;
                    partialRules.add(rule);
                    continue block0;
                }
                continue;
            }
            if (rule instanceof AbstractArithmeticRule) {
                for (Predicate predicate : ((AbstractArithmeticRule)rule).getBodyPredicates()) {
                    if (!partialPredicates.contains(predicate)) continue;
                    partialRules.add(rule);
                    continue block0;
                }
                continue;
            }
            throw new IllegalStateException("Unknown rule type: " + rule.getClass().getName());
        }
        return partialRules;
    }

    public static void partialComplexGround(AbstractArithmeticRule rule, GroundRuleStore groundRuleStore, AtomManager atomManager) {
        log.trace(String.format("Complex partial grounding on rule [%s]", rule));
        groundRuleStore.removeGroundRules(rule);
        rule.groundAll(atomManager, groundRuleStore);
    }

    public static void partialSimpleGround(Rule rule, Set<StandardPredicate> partialPredicates, GroundRuleStore groundRuleStore, AtomManager atomManager) {
        Database db = atomManager.getDatabase();
        if (!rule.supportsGroundingQueryRewriting()) {
            throw new UnsupportedOperationException("Rule requires full regrounding: " + rule);
        }
        Formula formula = rule.getRewritableGroundingFormula();
        QueryResultIterable groundingResults = PartialGrounding.getPartialGroundingResults(formula, partialPredicates, db);
        if (groundingResults == null) {
            return;
        }
        log.trace(String.format("Simple partial grounding on rule: [%s], formula: [%s]", rule, formula));
        Iterator groundingResultsIterator = groundingResults.iterator();
        ArrayList<GroundRule> groundRules = new ArrayList<GroundRule>();
        while (groundingResultsIterator.hasNext()) {
            Constant[] constants = (Constant[])groundingResultsIterator.next();
            groundRules.clear();
            rule.ground(constants, groundingResults.getVariableMap(), atomManager, groundRules);
            for (GroundRule groundRule : groundRules) {
                if (groundRule == null) continue;
                groundRuleStore.addGroundRule(groundRule);
            }
        }
    }

    private static List<Atom> getPartialTargetAtoms(Formula formula, Set<StandardPredicate> partialPredicates) {
        ArrayList<Atom> partialTargetAtoms = new ArrayList<Atom>();
        for (Atom atom : formula.getAtoms(new HashSet<Atom>())) {
            if (!partialPredicates.contains(atom.getPredicate())) continue;
            partialTargetAtoms.add(atom);
        }
        return partialTargetAtoms;
    }

    public static QueryResultIterable getPartialGroundingResults(Rule rule, Set<StandardPredicate> partialPredicates, Database db) {
        if (!rule.supportsGroundingQueryRewriting()) {
            throw new UnsupportedOperationException("Rule requires full regrounding: " + rule);
        }
        Formula formula = rule.getRewritableGroundingFormula();
        return PartialGrounding.getPartialGroundingResults(formula, partialPredicates, db);
    }

    private static QueryResultIterable getPartialGroundingResults(Formula formula, Set<StandardPredicate> partialPredicates, Database db) {
        List<Atom> partialTargetAtoms = PartialGrounding.getPartialTargetAtoms(formula, partialPredicates);
        if (partialTargetAtoms.size() == 0) {
            return null;
        }
        return PartialGrounding.partialGroundingIterable(formula, partialTargetAtoms, db);
    }

    private static QueryResultIterable partialGroundingIterable(Formula formula, List<Atom> allPartialTargetAtoms, Database db) {
        if (allPartialTargetAtoms.size() == 0) {
            throw new IllegalArgumentException();
        }
        RDBMSDatabase relationalDB = (RDBMSDatabase)db;
        ArrayList<SelectQuery> queries = new ArrayList<SelectQuery>();
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        Map<Variable, Integer> projectionMap = null;
        ArrayList<Atom> partialTargetAtoms = new ArrayList<Atom>();
        Iterable<boolean[]> subsetIterable = null;
        int partialTargetIndex = 0;
        int numPartialTargets = 0;
        if (Options.PARTIAL_GROUNDING_POWERSET.getBoolean()) {
            subsetIterable = IteratorUtils.powerset(allPartialTargetAtoms.size());
        } else {
            subsetIterable = new ArrayList<boolean[]>();
            for (int i = 0; i < allPartialTargetAtoms.size(); ++i) {
                boolean[] subset = new boolean[allPartialTargetAtoms.size()];
                subset[i] = true;
                ((List)subsetIterable).add(subset);
            }
        }
        for (boolean[] partialTargetAtomSubset : subsetIterable) {
            partialTargetAtoms.clear();
            partialTargetIndex = 0;
            numPartialTargets = 0;
            for (boolean bool : partialTargetAtomSubset) {
                if (bool) {
                    partialTargetAtoms.add(allPartialTargetAtoms.get(partialTargetIndex));
                    ++numPartialTargets;
                }
                ++partialTargetIndex;
            }
            if (numPartialTargets == 0) continue;
            Formula2SQL sqler = new Formula2SQL(varTypes.getVariables(), relationalDB, false, partialTargetAtoms);
            queries.add(sqler.getQuery(formula));
            if (projectionMap != null) continue;
            projectionMap = sqler.getProjectionMap();
        }
        if (queries.size() == 0) {
            return null;
        }
        UnionQuery union = new UnionQuery(SetOperationQuery.Type.UNION_ALL, queries.toArray(new SelectQuery[0]));
        return relationalDB.executeQueryIterator(projectionMap, varTypes, ((UnionQuery)union.validate()).toString());
    }
}

