/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.linqs.psl.application.inference.online.messages.OnlineMessage;
import org.linqs.psl.application.inference.online.messages.actions.controls.Exit;
import org.linqs.psl.application.inference.online.messages.actions.controls.Stop;
import org.linqs.psl.application.inference.online.messages.actions.controls.Sync;
import org.linqs.psl.application.inference.online.messages.actions.controls.WriteInferredPredicates;
import org.linqs.psl.application.inference.online.messages.actions.model.AddAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.DeleteAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.GetAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.ObserveAtom;
import org.linqs.psl.application.inference.online.messages.actions.model.UpdateObservation;
import org.linqs.psl.application.inference.online.messages.actions.template.ActivateRule;
import org.linqs.psl.application.inference.online.messages.actions.template.AddRule;
import org.linqs.psl.application.inference.online.messages.actions.template.DeactivateRule;
import org.linqs.psl.application.inference.online.messages.actions.template.DeleteRule;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.parser.ModelLoader;
import org.linqs.psl.parser.antlr.OnlinePSLBaseVisitor;
import org.linqs.psl.parser.antlr.OnlinePSLLexer;
import org.linqs.psl.parser.antlr.OnlinePSLParser;

public class OnlineActionLoader
extends OnlinePSLBaseVisitor<Object> {
    public static OnlineMessage loadAction(String input) {
        List<OnlineMessage> actions = OnlineActionLoader.load(new StringReader(input));
        if (actions.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected 1 action, found %d.", actions.size()));
        }
        return actions.get(0);
    }

    public static List<OnlineMessage> load(String input) {
        return OnlineActionLoader.load(new StringReader(input));
    }

    public static List<OnlineMessage> load(Reader input) {
        OnlinePSLParser parser = null;
        try {
            parser = OnlineActionLoader.getParser(input);
        }
        catch (IOException ex) {
            throw new ParseCancellationException("Failed to lex action.", ex);
        }
        OnlinePSLParser.OnlineProgramContext onlineProgram = null;
        onlineProgram = parser.onlineProgram();
        OnlineActionLoader visitor = new OnlineActionLoader();
        return visitor.visitOnlineProgram(onlineProgram, parser);
    }

    private static OnlinePSLParser getParser(Reader input) throws IOException {
        OnlinePSLLexer lexer = new OnlinePSLLexer(CharStreams.fromReader(input));
        lexer.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) throws ParseCancellationException {
                throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg, ex);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        OnlinePSLParser parser = new OnlinePSLParser(tokens);
        parser.setErrorHandler(new BailErrorStrategy());
        return parser;
    }

    private OnlineActionLoader() {
    }

    public List<OnlineMessage> visitOnlineProgram(OnlinePSLParser.OnlineProgramContext ctx, OnlinePSLParser parser) {
        LinkedList<OnlineMessage> actions = new LinkedList<OnlineMessage>();
        for (OnlinePSLParser.ActionContext actionCtx : ctx.action()) {
            try {
                actions.add((OnlineMessage)this.visit(actionCtx));
            }
            catch (RuntimeException ex) {
                throw new ParseCancellationException("Failed to compile online action: [" + parser.getTokenStream().getText(actionCtx) + "]", ex);
            }
        }
        return actions;
    }

    @Override
    public OnlineMessage visitAction(OnlinePSLParser.ActionContext ctx) {
        if (ctx.addAtom() != null) {
            return this.visitAddAtom(ctx.addAtom());
        }
        if (ctx.addRule() != null) {
            return this.visitAddRule(ctx.addRule());
        }
        if (ctx.deleteRule() != null) {
            return this.visitDeleteRule(ctx.deleteRule());
        }
        if (ctx.activateRule() != null) {
            return this.visitActivateRule(ctx.activateRule());
        }
        if (ctx.deactivateRule() != null) {
            return this.visitDeactivateRule(ctx.deactivateRule());
        }
        if (ctx.deleteAtom() != null) {
            return this.visitDeleteAtom(ctx.deleteAtom());
        }
        if (ctx.exit() != null) {
            return this.visitExit(ctx.exit());
        }
        if (ctx.observeAtom() != null) {
            return this.visitObserveAtom(ctx.observeAtom());
        }
        if (ctx.getAtom() != null) {
            return this.visitGetAtom(ctx.getAtom());
        }
        if (ctx.stop() != null) {
            return this.visitStop(ctx.stop());
        }
        if (ctx.sync() != null) {
            return this.visitSync(ctx.sync());
        }
        if (ctx.updateObservation() != null) {
            return this.visitUpdateObservation(ctx.updateObservation());
        }
        if (ctx.writeInferredPredicates() != null) {
            return this.visitWriteInferredPredicates(ctx.writeInferredPredicates());
        }
        throw new IllegalStateException();
    }

    @Override
    public AddAtom visitAddAtom(OnlinePSLParser.AddAtomContext ctx) {
        Atom atom = ModelLoader.loadAtom(ctx.atom().getText());
        Constant[] constants = new Constant[atom.getArguments().length];
        for (int i = 0; i < constants.length; ++i) {
            constants[i] = (Constant)atom.getArguments()[i];
        }
        String partition = ctx.PARTITION().getText();
        if (ctx.number() == null) {
            return new AddAtom(partition, (StandardPredicate)atom.getPredicate(), constants);
        }
        return new AddAtom(partition, (StandardPredicate)atom.getPredicate(), constants, this.visitNumber(ctx.number()).floatValue());
    }

    @Override
    public DeleteAtom visitDeleteAtom(OnlinePSLParser.DeleteAtomContext ctx) {
        Atom atom = ModelLoader.loadAtom(ctx.atom().getText());
        Constant[] constants = new Constant[atom.getArguments().length];
        for (int i = 0; i < constants.length; ++i) {
            constants[i] = (Constant)atom.getArguments()[i];
        }
        String partition = ctx.PARTITION().getText();
        return new DeleteAtom(partition, (StandardPredicate)atom.getPredicate(), constants);
    }

    @Override
    public ObserveAtom visitObserveAtom(OnlinePSLParser.ObserveAtomContext ctx) {
        Atom atom = ModelLoader.loadAtom(ctx.atom().getText());
        Constant[] constants = new Constant[atom.getArguments().length];
        for (int i = 0; i < constants.length; ++i) {
            constants[i] = (Constant)atom.getArguments()[i];
        }
        float value = this.visitNumber(ctx.number()).floatValue();
        return new ObserveAtom((StandardPredicate)atom.getPredicate(), constants, value);
    }

    @Override
    public UpdateObservation visitUpdateObservation(OnlinePSLParser.UpdateObservationContext ctx) {
        Atom atom = ModelLoader.loadAtom(ctx.atom().getText());
        Constant[] constants = new Constant[atom.getArguments().length];
        for (int i = 0; i < constants.length; ++i) {
            constants[i] = (Constant)atom.getArguments()[i];
        }
        float value = this.visitNumber(ctx.number()).floatValue();
        return new UpdateObservation((StandardPredicate)atom.getPredicate(), constants, value);
    }

    @Override
    public GetAtom visitGetAtom(OnlinePSLParser.GetAtomContext ctx) {
        Atom atom = ModelLoader.loadAtom(ctx.atom().getText());
        Constant[] constants = new Constant[atom.getArguments().length];
        for (int i = 0; i < constants.length; ++i) {
            constants[i] = (Constant)atom.getArguments()[i];
        }
        return new GetAtom((StandardPredicate)atom.getPredicate(), constants);
    }

    @Override
    public AddRule visitAddRule(OnlinePSLParser.AddRuleContext ctx) {
        Rule rule = ModelLoader.loadRule(ctx.pslRule().getText());
        return new AddRule(rule);
    }

    @Override
    public DeleteRule visitDeleteRule(OnlinePSLParser.DeleteRuleContext ctx) {
        Rule rule = ModelLoader.loadRule(ctx.pslRule().getText());
        return new DeleteRule(rule);
    }

    @Override
    public ActivateRule visitActivateRule(OnlinePSLParser.ActivateRuleContext ctx) {
        Rule rule = ModelLoader.loadRule(ctx.pslRule().getText());
        return new ActivateRule(rule);
    }

    @Override
    public DeactivateRule visitDeactivateRule(OnlinePSLParser.DeactivateRuleContext ctx) {
        Rule rule = ModelLoader.loadRule(ctx.pslRule().getText());
        return new DeactivateRule(rule);
    }

    @Override
    public Exit visitExit(OnlinePSLParser.ExitContext ctx) {
        return new Exit();
    }

    @Override
    public Stop visitStop(OnlinePSLParser.StopContext ctx) {
        return new Stop();
    }

    @Override
    public Sync visitSync(OnlinePSLParser.SyncContext ctx) {
        return new Sync();
    }

    @Override
    public WriteInferredPredicates visitWriteInferredPredicates(OnlinePSLParser.WriteInferredPredicatesContext ctx) {
        String outputDirectoryPath = ctx.STRING_LITERAL().getText().substring(1, ctx.STRING_LITERAL().getText().length() - 1);
        return new WriteInferredPredicates(outputDirectoryPath);
    }

    @Override
    public Float visitNumber(OnlinePSLParser.NumberContext ctx) {
        return Float.valueOf(Float.parseFloat(ctx.getText()));
    }
}

