/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner;

import java.util.List;
import java.util.Set;
import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.config.Options;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Logger;

public abstract class Reasoner {
    private static final Logger log = Logger.getLogger(Reasoner.class);
    protected double budget = 1.0;
    protected boolean evaluate = Options.REASONER_EVALUATE.getBoolean();
    protected boolean objectiveBreak = Options.REASONER_OBJECTIVE_BREAK.getBoolean();
    protected boolean runFullIterations = Options.REASONER_RUN_FULL_ITERATIONS.getBoolean();
    protected float tolerance = Options.REASONER_TOLERANCE.getFloat();
    protected boolean nonconvex = Options.REASONER_NONCONVEX.getBoolean();
    protected int nonconvexPeriod = Options.REASONER_NONCONVEX_PERIOD.getInt();
    protected int nonconvexRounds = Options.REASONER_NONCONVEX_ROUNDS.getInt();

    public double optimize(TermStore termStore) {
        return this.optimize(termStore, null, null, null);
    }

    public abstract double optimize(TermStore var1, List<Evaluator> var2, TrainingMap var3, Set<StandardPredicate> var4);

    public abstract void close();

    public void setBudget(double budget) {
        this.budget = budget;
    }

    protected void evaluate(TermStore termStore, int iteration, List<Evaluator> evaluators, TrainingMap trainingMap, Set<StandardPredicate> evaluationPredicates) {
        if (!this.evaluate) {
            return;
        }
        if (trainingMap == null || evaluators == null || evaluators.size() == 0 || evaluationPredicates == null || evaluationPredicates.size() == 0) {
            return;
        }
        termStore.syncAtoms();
        for (Evaluator evaluator : evaluators) {
            for (StandardPredicate predicate : evaluationPredicates) {
                evaluator.compute(trainingMap, predicate);
                log.info("Iteration {} -- Evaluator: {}, Predicate: {}, Results -- {}.", iteration, evaluator.getClass().getSimpleName(), predicate.getName(), evaluator.getAllStats());
            }
        }
    }
}

