/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.nio.ByteBuffer;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.AbstractRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;

public class DCDObjectiveTerm
implements StreamingTerm {
    private boolean squared;
    private WeightedRule rule;
    private float constant;
    private float lagrange;
    private float qii;
    private float c;
    private short size;
    private float[] coefficients;
    private int[] variableIndexes;

    public DCDObjectiveTerm(VariableTermStore<DCDObjectiveTerm, GroundAtom> termStore, WeightedRule rule, boolean squared, Hyperplane<GroundAtom> hyperplane, float c) {
        this.squared = squared;
        this.size = (short)hyperplane.size();
        this.coefficients = hyperplane.getCoefficients();
        this.constant = hyperplane.getConstant();
        this.variableIndexes = new int[this.size];
        GroundAtom[] variables = (GroundAtom[])hyperplane.getVariables();
        for (int i = 0; i < this.size; ++i) {
            this.variableIndexes[i] = termStore.getVariableIndex(variables[i]);
        }
        this.rule = rule;
        this.c = c;
        float tempQii = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            tempQii += this.coefficients[i] * this.coefficients[i];
        }
        this.qii = tempQii;
        this.lagrange = 0.0f;
    }

    public float evaluate(float[] variableValues) {
        float value = 0.0f;
        float adjustedWeight = this.rule.getWeight() * this.c;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * variableValues[this.variableIndexes[i]];
        }
        value -= this.constant;
        if (this.squared) {
            return adjustedWeight * (float)Math.pow(Math.max(0.0f, value), 2.0);
        }
        return adjustedWeight * Math.max(value, 0.0f);
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isSquared() {
        return this.squared;
    }

    @Override
    public void adjustConstant(float oldValue, float newValue) {
        this.constant = this.constant - oldValue + newValue;
    }

    @Override
    public boolean isConvex() {
        return true;
    }

    public float computeGradient(float[] variableValues) {
        float val = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            val += variableValues[this.variableIndexes[i]] * this.coefficients[i];
        }
        return this.constant - val;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public float getLagrange() {
        return this.lagrange;
    }

    public void setLagrange(float lagrange) {
        this.lagrange = lagrange;
    }

    public WeightedRule getRule() {
        return this.rule;
    }

    public int[] getVariableIndexes() {
        return this.variableIndexes;
    }

    public float getQii() {
        return this.qii;
    }

    @Override
    public int fixedByteSize() {
        int bitSize = 152 + this.size * 64;
        return bitSize / 8;
    }

    @Override
    public void writeFixedValues(ByteBuffer fixedBuffer) {
        fixedBuffer.put((byte)(this.squared ? 1 : 0));
        fixedBuffer.putInt(this.rule.hashCode());
        fixedBuffer.putFloat(this.constant);
        fixedBuffer.putFloat(this.qii);
        fixedBuffer.putFloat(this.c);
        fixedBuffer.putShort(this.size);
        for (int i = 0; i < this.size; ++i) {
            fixedBuffer.putFloat(this.coefficients[i]);
            fixedBuffer.putInt(this.variableIndexes[i]);
        }
    }

    @Override
    public void read(ByteBuffer fixedBuffer, ByteBuffer volatileBuffer) {
        this.squared = fixedBuffer.get() == 1;
        this.rule = (WeightedRule)AbstractRule.getRule(fixedBuffer.getInt());
        this.constant = fixedBuffer.getFloat();
        this.qii = fixedBuffer.getFloat();
        this.c = fixedBuffer.getFloat();
        this.size = fixedBuffer.getShort();
        if (this.coefficients.length < this.size) {
            this.coefficients = new float[this.size];
            this.variableIndexes = new int[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.coefficients[i] = fixedBuffer.getFloat();
            this.variableIndexes[i] = fixedBuffer.getInt();
        }
        this.lagrange = volatileBuffer.getFloat();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(float[] variableValues) {
        StringBuilder builder = new StringBuilder();
        builder.append("" + this.rule.getWeight() + " * " + this.c);
        builder.append(" * max(0.0, ");
        for (int i = 0; i < this.size; ++i) {
            builder.append("(");
            builder.append(this.coefficients[i]);
            if (variableValues == null) {
                builder.append(" * <index:");
                builder.append(this.variableIndexes[i]);
                builder.append(">)");
            } else {
                builder.append(" * ");
                builder.append(variableValues[this.variableIndexes[i]]);
                builder.append(")");
            }
            if (i == this.size - 1) continue;
            builder.append(" + ");
        }
        builder.append(" - ");
        builder.append(this.constant);
        builder.append(")");
        if (this.squared) {
            builder.append("^2");
        }
        return builder.toString();
    }
}

