/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.util.Collection;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.util.Logger;

public class DCDTermGenerator
extends HyperplaneTermGenerator<DCDObjectiveTerm, GroundAtom> {
    private static final Logger log = Logger.getLogger(DCDTermGenerator.class);
    private float c = Options.DCD_C.getFloat();

    public DCDTermGenerator() {
        this(true);
    }

    public DCDTermGenerator(boolean mergeConstants) {
        super(mergeConstants);
    }

    @Override
    public Class<GroundAtom> getLocalVariableType() {
        return GroundAtom.class;
    }

    @Override
    public int createLossTerm(Collection<DCDObjectiveTerm> newTerms, TermStore<DCDObjectiveTerm, GroundAtom> baseTermStore, boolean isHinge, boolean isSquared, GroundRule groundRule, Hyperplane<GroundAtom> hyperplane) {
        VariableTermStore termStore = (VariableTermStore)baseTermStore;
        if (isHinge && isSquared) {
            newTerms.add(new DCDObjectiveTerm(termStore, ((WeightedGroundRule)groundRule).getRule(), true, hyperplane, this.c));
            return 1;
        }
        if (isHinge && !isSquared) {
            newTerms.add(new DCDObjectiveTerm(termStore, ((WeightedGroundRule)groundRule).getRule(), false, hyperplane, this.c));
            return 1;
        }
        if (!isHinge && isSquared) {
            log.warn("DCD does not support squared linear terms: " + groundRule);
            return 0;
        }
        log.warn("DCD does not support linear terms: " + groundRule);
        return 0;
    }

    @Override
    public int createLinearConstraintTerm(Collection<DCDObjectiveTerm> newTerms, TermStore<DCDObjectiveTerm, GroundAtom> termStore, GroundRule groundRule, Hyperplane<GroundAtom> hyperplane, FunctionComparator comparator) {
        log.warn("DCD does not support hard constraints, i.e. " + groundRule);
        return 0;
    }
}

