/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Arrays;

public final class StringUtils {
    private StringUtils() {
    }

    public static int[] splitInt(String text, char delim) {
        return StringUtils.splitInt(text, "" + delim);
    }

    public static int[] splitInt(String text, String delim) {
        String[] parts = text.split(delim);
        int[] ints = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ints[i] = Integer.parseInt(parts[i]);
        }
        return ints;
    }

    public static long[] splitLong(String text, char delim) {
        return StringUtils.splitLong(text, "" + delim);
    }

    public static long[] splitLong(String text, String delim) {
        String[] parts = text.split(delim);
        long[] longs = new long[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            longs[i] = Long.parseLong(parts[i]);
        }
        return longs;
    }

    public static float[] splitFloat(String text, char delim) {
        return StringUtils.splitFloat(text, "" + delim);
    }

    public static float[] splitFloat(String text, String delim) {
        String[] parts = text.split(delim);
        float[] floats = new float[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            floats[i] = Float.parseFloat(parts[i]);
        }
        return floats;
    }

    public static double[] splitDouble(String text, char delim) {
        return StringUtils.splitDouble(text, "" + delim);
    }

    public static double[] splitDouble(String text, String delim) {
        String[] parts = text.split(delim);
        double[] doubles = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            doubles[i] = Double.parseDouble(parts[i]);
        }
        return doubles;
    }

    public static String join(char delim, Object ... parts) {
        return StringUtils.join("" + delim, parts);
    }

    public static String join(String delim, Object ... parts) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(char delim, int ... parts) {
        return StringUtils.join("" + delim, parts);
    }

    public static String join(String delim, int ... parts) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(char delim, long ... parts) {
        return StringUtils.join("" + delim, parts);
    }

    public static String join(String delim, long ... parts) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(char delim, float ... parts) {
        return StringUtils.join("" + delim, parts);
    }

    public static String join(String delim, float ... parts) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(char delim, double ... parts) {
        return StringUtils.join("" + delim, parts);
    }

    public static String join(String delim, double ... parts) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String repeat(String text, int times) {
        return StringUtils.repeat(text, "", times);
    }

    public static String repeat(String text, String delim, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("Cannot repeat a string negative times.");
        }
        if (times == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(times * 2);
        for (int i = 0; i < times; ++i) {
            builder.append(text);
            if (i == times - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String sort(String string) {
        char[] chars = string.toCharArray();
        Arrays.sort(chars);
        return new String(chars);
    }
}

