import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { GetDeploymentConfigInput, GetDeploymentConfigOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetDeploymentConfigCommand}.
 */
export interface GetDeploymentConfigCommandInput extends GetDeploymentConfigInput {
}
/**
 * @public
 *
 * The output of {@link GetDeploymentConfigCommand}.
 */
export interface GetDeploymentConfigCommandOutput extends GetDeploymentConfigOutput, __MetadataBearer {
}
declare const GetDeploymentConfigCommand_base: {
    new (input: GetDeploymentConfigCommandInput): import("@smithy/smithy-client").CommandImpl<GetDeploymentConfigCommandInput, GetDeploymentConfigCommandOutput, CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Gets information about a deployment configuration.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, GetDeploymentConfigCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, GetDeploymentConfigCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // GetDeploymentConfigInput
 *   deploymentConfigName: "STRING_VALUE", // required
 * };
 * const command = new GetDeploymentConfigCommand(input);
 * const response = await client.send(command);
 * // { // GetDeploymentConfigOutput
 * //   deploymentConfigInfo: { // DeploymentConfigInfo
 * //     deploymentConfigId: "STRING_VALUE",
 * //     deploymentConfigName: "STRING_VALUE",
 * //     minimumHealthyHosts: { // MinimumHealthyHosts
 * //       type: "HOST_COUNT" || "FLEET_PERCENT",
 * //       value: Number("int"),
 * //     },
 * //     createTime: new Date("TIMESTAMP"),
 * //     computePlatform: "Server" || "Lambda" || "ECS",
 * //     trafficRoutingConfig: { // TrafficRoutingConfig
 * //       type: "TimeBasedCanary" || "TimeBasedLinear" || "AllAtOnce",
 * //       timeBasedCanary: { // TimeBasedCanary
 * //         canaryPercentage: Number("int"),
 * //         canaryInterval: Number("int"),
 * //       },
 * //       timeBasedLinear: { // TimeBasedLinear
 * //         linearPercentage: Number("int"),
 * //         linearInterval: Number("int"),
 * //       },
 * //     },
 * //     zonalConfig: { // ZonalConfig
 * //       firstZoneMonitorDurationInSeconds: Number("long"),
 * //       monitorDurationInSeconds: Number("long"),
 * //       minimumHealthyHostsPerZone: { // MinimumHealthyHostsPerZone
 * //         type: "HOST_COUNT" || "FLEET_PERCENT",
 * //         value: Number("int"),
 * //       },
 * //     },
 * //   },
 * // };
 *
 * ```
 *
 * @param GetDeploymentConfigCommandInput - {@link GetDeploymentConfigCommandInput}
 * @returns {@link GetDeploymentConfigCommandOutput}
 * @see {@link GetDeploymentConfigCommandInput} for command's `input` shape.
 * @see {@link GetDeploymentConfigCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link DeploymentConfigDoesNotExistException} (client fault)
 *  <p>The deployment configuration does not exist with the user or Amazon Web Services account.</p>
 *
 * @throws {@link DeploymentConfigNameRequiredException} (client fault)
 *  <p>The deployment configuration name was not specified.</p>
 *
 * @throws {@link InvalidComputePlatformException} (client fault)
 *  <p>The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</p>
 *
 * @throws {@link InvalidDeploymentConfigNameException} (client fault)
 *  <p>The deployment configuration name was specified in an invalid format.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class GetDeploymentConfigCommand extends GetDeploymentConfigCommand_base {
}
