"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .metadata import Metadata, MetadataTypedDict
from .mode import Mode
from .url import URL, URLTypedDict
from .url_nullable import URLNullable, URLNullableTypedDict
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityRefundResponseStatus(str, Enum):
    r"""Refunds may take some time to get confirmed."""

    QUEUED = "queued"
    PENDING = "pending"
    PROCESSING = "processing"
    REFUNDED = "refunded"
    FAILED = "failed"
    CANCELED = "canceled"


class EntityRefundResponseType(str, Enum):
    r"""Specifies the reference type"""

    ACQUIRER_REFERENCE = "acquirer-reference"


class EntityRefundResponseExternalReferenceTypedDict(TypedDict):
    type: NotRequired[EntityRefundResponseType]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class EntityRefundResponseExternalReference(BaseModel):
    type: Optional[EntityRefundResponseType] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class EntityRefundResponseSourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    organization_id: NotRequired[str]


class EntityRefundResponseSource(BaseModel):
    r"""Where the funds will be pulled back from."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None


class EntityRefundResponseRoutingReversalTypedDict(TypedDict):
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    source: NotRequired[EntityRefundResponseSourceTypedDict]
    r"""Where the funds will be pulled back from."""


class EntityRefundResponseRoutingReversal(BaseModel):
    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    source: Optional[EntityRefundResponseSource] = None
    r"""Where the funds will be pulled back from."""


class EntityRefundResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityRefundResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntityRefundResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: str
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    metadata: Nullable[MetadataTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    status: EntityRefundResponseStatus
    r"""Refunds may take some time to get confirmed."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: EntityRefundResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    settlement_amount: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    payment_id: NotRequired[str]
    settlement_id: NotRequired[str]
    external_reference: NotRequired[EntityRefundResponseExternalReferenceTypedDict]
    routing_reversals: NotRequired[
        Nullable[List[EntityRefundResponseRoutingReversalTypedDict]]
    ]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """


class EntityRefundResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: str

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    metadata: Nullable[Metadata]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    status: EntityRefundResponseStatus
    r"""Refunds may take some time to get confirmed."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[EntityRefundResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    settlement_amount: Annotated[
        OptionalNullable[AmountNullable], pydantic.Field(alias="settlementAmount")
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None

    external_reference: Annotated[
        Optional[EntityRefundResponseExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    routing_reversals: Annotated[
        OptionalNullable[List[EntityRefundResponseRoutingReversal]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "settlementAmount",
            "paymentId",
            "settlementId",
            "externalReference",
            "routingReversals",
        ]
        nullable_fields = ["settlementAmount", "metadata", "routingReversals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
