"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currencies import Currencies
from .entity_settlement import EntitySettlement, EntitySettlementTypedDict
from .list_links import ListLinks, ListLinksTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListSettlementsRequestTypedDict(TypedDict):
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    balance_id: NotRequired[str]
    r"""Provide the token of the balance to filter the settlements by. This is
    the balance token that the settlement was settled to.
    """
    year: NotRequired[Nullable[str]]
    r"""Provide the year to query the settlements. Must be used combined with `month` parameter"""
    month: NotRequired[Nullable[str]]
    r"""Provide the month to query the settlements. Must be used combined with `year` parameter"""
    currencies: NotRequired[Currencies]
    r"""Provides the currencies to retrieve the settlements. It accepts multiple currencies in a comma-separated format."""


class ListSettlementsRequest(BaseModel):
    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    balance_id: Annotated[
        Optional[str],
        pydantic.Field(alias="balanceId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide the token of the balance to filter the settlements by. This is
    the balance token that the settlement was settled to.
    """

    year: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide the year to query the settlements. Must be used combined with `month` parameter"""

    month: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide the month to query the settlements. Must be used combined with `year` parameter"""

    currencies: Annotated[
        Annotated[Optional[Currencies], PlainValidator(validate_open_enum(False))],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provides the currencies to retrieve the settlements. It accepts multiple currencies in a comma-separated format."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "balanceId", "year", "month", "currencies"]
        nullable_fields = ["from", "limit", "year", "month"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementsEmbeddedTypedDict(TypedDict):
    settlements: NotRequired[List[EntitySettlementTypedDict]]
    r"""An array of settlement objects. For a complete reference
    of the settlement object, refer to the [Get settlement endpoint](get-settlement) documentation.
    """


class ListSettlementsEmbedded(BaseModel):
    settlements: Optional[List[EntitySettlement]] = None
    r"""An array of settlement objects. For a complete reference
    of the settlement object, refer to the [Get settlement endpoint](get-settlement) documentation.
    """


class ListSettlementsResponseTypedDict(TypedDict):
    r"""A list of settlement objects. For a complete reference of the settlement
    object, refer to the [Get settlement endpoint](get-settlement) documentation.
    """

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListSettlementsEmbeddedTypedDict]
    links: NotRequired[ListLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListSettlementsResponse(BaseModel):
    r"""A list of settlement objects. For a complete reference of the settlement
    object, refer to the [Get settlement endpoint](get-settlement) documentation.
    """

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListSettlementsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
