"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from enum import Enum
from mollie.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLineItemResponseType(str, Enum):
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    PHYSICAL = "physical"
    DIGITAL = "digital"
    SHIPPING_FEE = "shipping_fee"
    DISCOUNT = "discount"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"
    TIP = "tip"


class PaymentLineItemResponseCategory(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class PaymentLineItemResponseTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    type: NotRequired[PaymentLineItemResponseType]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[PaymentLineItemResponseCategory]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""


class PaymentLineItemResponse(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[Amount, pydantic.Field(alias="unitPrice")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[Amount, pydantic.Field(alias="totalAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    type: Optional[PaymentLineItemResponseType] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[Optional[Amount], pydantic.Field(alias="vatAmount")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[PaymentLineItemResponseCategory]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""
