"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .route_get_response import RouteGetResponse, RouteGetResponseTypedDict
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentListRoutesRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class PaymentListRoutesRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentListRoutesEmbeddedTypedDict(TypedDict):
    routes: NotRequired[List[RouteGetResponseTypedDict]]
    r"""An array of route objects."""


class PaymentListRoutesEmbedded(BaseModel):
    routes: Optional[List[RouteGetResponse]] = None
    r"""An array of route objects."""


class PaymentListRoutesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesResponseTypedDict(TypedDict):
    r"""A list of route objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[PaymentListRoutesEmbeddedTypedDict]
    links: NotRequired[PaymentListRoutesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class PaymentListRoutesResponse(BaseModel):
    r"""A list of route objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[PaymentListRoutesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[PaymentListRoutesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
