"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .url import URL, URLTypedDict
from enum import Enum
from mollie.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class RouteGetResponseType(str, Enum):
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    ORGANIZATION = "organization"


class RouteGetResponseDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: RouteGetResponseType
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class RouteGetResponseDestination(BaseModel):
    r"""The destination of the route."""

    type: RouteGetResponseType
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class RouteGetResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteGetResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteGetResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    payment_id: str
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str
    r"""The description of the route. This description is shown in the reports."""
    destination: RouteGetResponseDestinationTypedDict
    r"""The destination of the route."""
    links: RouteGetResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class RouteGetResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str
    r"""The description of the route. This description is shown in the reports."""

    destination: RouteGetResponseDestination
    r"""The destination of the route."""

    links: Annotated[RouteGetResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
