from ..tools.get_product_id import get_product_id
from ..errors.exceptions import InvalidArgumentException


def get_list_as_string(value):
    if value is None:
        return None

    if isinstance(value, str):
        return value

    elif isinstance(value, list):
        return ','.join(value)

    else:
        raise InvalidArgumentException('Argument should be a list or string: ' + str(value))


def get_product_ids(values):
    if isinstance(values, str):
        values = values.split(',')

    elif not isinstance(values, list):
        raise InvalidArgumentException('Argument product_ids should be a list or string')

    product_ids = []
    for value in values:
        product_ids.append(get_product_id(value))

    return product_ids
