#   Copyright 1999-2000 Michael Hudson mwh@python.net
#
#                        All Rights Reserved
#
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear in
# supporting documentation.
#
# THE AUTHOR MICHAEL HUDSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
# INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

import string

class MethodSpecifier:
    """\
This class enables the specialisation of methods when
the bytecodehacks/ops.py file is autogenerated"""

    def __init__(self,spec_file):
        self.load_from_file(spec_file)
    def has_method(self,method):
        return self.methods.has_key(method)
    def get_method_body(self,method):
        return self.methods[method]
    def get_method(self,method):
        return self.template%self.get_method_body(method)
    def load_from_file(self,file):
        self.methods = {}
        lines = open(file).readlines()

        lines = filter(lambda l:l[0] <> '#',lines)
        lines = map(lambda l:l[:-1],lines)

        n = len(lines)
        names = []
        i = 0
        
        while i < n:
            if not lines[i]:
                i = i + 1
                continue
            if lines[i][0] in string.whitespace:
                body = []
                while (i < n
                       and lines[i]
                       and lines[i][0] in string.whitespace):
                    body.append(lines[i])
                    i = i + 1
                body = '    '+string.join(body,'\n    ')
                for name in names:
                    self.methods[name] = body
                names = []
            else:
                names.append(string.split(lines[i],':',1)[0])
                i = i + 1

        if names <> []:
            raise "malformed input? (names <> [])"
    def set_template(self,template):
        self.template = template
                
