from divinegift.cipher import decrypt_str, get_cipher, encrypt_str

cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='

console_template = b'gAAAAABcgMESrXnGipoZYtUP-WCTO4_roKf1Zf5xuE5ricJ9Tty_Z15Ypp7XnHifMnB0OV-tyLhGesby-O0UMdXx9ePIdmrPZrTrKhlW0abpxnX24w3onwOhEfO46smJ_d0wNrt2pPtFm37DtrqeVcJBzRomlEPD2RFU48EefVzW2gsIkRvSvGOnKreKg4CeTz3z42WXuoCjbU7H7l3tV1TPyU0I0kqA2VGFENEXQbfnpCR9Q1WiI28BUHU3FKvu239unk0HLTTL578LfUUzeXklrFeIE-j6Yhth78sbxO8fYReSq8ShX3MPwMtsZKd5xGxI1tyhjzV4yiwuaFKcrfxAV3Lch4w4Dqr-K3OwIc5A5NBz3p64vPSskGED006CM5_IrcawoFDvwRhRZGfVYxbn8EytWXPeQfNUqxrmQkq2G7DGyQA3woTp5E15Fc1ZuDMieM6yMS3l3k1LFkzp3mu8Gh-a3hIjeHBB5hkZHEGIj1CoXnoHgqZuHszEQ3Cb9Sb6hmhYCebbRScUF_GOzkj0DwHFV_lq8e4CtVISPsdqIQ3OcLje3gvlVmdAH2UT6sTjaAtuZn59s_L0x67mTtq7vHxR4tpLNaqwSsyXSqi4WdXTxdWQv_-K5TUVBFbA2t8HlkGtSR6IY8iMIs5CwLf9fEQuqkqCx3GW1bA31Cl7gzMS3wBVEQVY6aAORwnETlGUYFbJd8pUAOsOGcAESuKpU1w_uxc-T567yJ6szVEmpse0wHvT_Gwr0sE4PLGn3N4OkyIxybFXbeQUBLK5XVjkFHXZJlOCD6C1-8KeZLWuzlAKLFEoxuECXqnw2FqmqoB9P1QVqFSqBt9GO3mC57NYyrFIGb4zguQjJbjzyxMU_qchuWWhTROGg9f8_fi7z9rZ9FCwtCgCmhIcN52c6Yo9t_V0gaC3O8O-JYFVtayCmB-Ssm6dmGe6HZHCCq2cXL8RPnM9UM-e0vcK2UKH8iR5FRlH0SM3tN1qPqHmGsdiIluTj8ETK1tWR1zbAuhUKyoiLmHakm0MWHn-3sssp5I83PqOc2uyiuKJtiCxDo5aGQ5zABjGjT1Q9ViYWoZwx_2W6P2otKFZsvVCs9fZ8DPJzMN4aOemzfqVRPeWFjqLpb2QZDQUBVrx8kthxl7fwdEs4-4HHQJw78wfyjvdwPdQgUWNO4yWsfG50X29R3HDfRpdqg4Drk1dguQtcXI0BDPokMYjKPiNYB_RLRf5MXJyigTK6IprVV917a8CLhetsB3m0sDGmnBlPOA9HHayaocnikno52kc7jT8qK6-rhYoVUmCB4iUDGfz75OcW0wXqIoRxKhCARk9Qam9Vqo5hSzbsZ9ZkkEM6buOE6OVF0wUejkm70KCKdgrOWmGq73yoStGgyScar6fCfWsYgJINtz2ul-fO5P_hPYFmzQvCkP4rhl7rIm5bl070aKm7di9Pl1GTLhlCap6qit9UB6vpERCGX2iDoBP3hb_1VdmHlLE1-jqbzJMQDJM2382pUawZ76oXK-Yv9ghLljbcyJ3DWzOvytAB72eKW7JiLaOy_lfqYUBL6ev4haTuI8DomDP9OQBx3eDfYF8GAX7xxizPLvwHgfFk6MbrJU5Jatd6B9cAxVUht-NvpuNAQbMT-7fcbCbcWVb-sO3Us3W6dkI0kamUYqdzF5B-U9M-o6nIyKZQVAdOlK6WkWBkavA9Fs5aobclOkzg2dngRfCYRC4-ntTKxw4m5MkVzNdZLMUuD0opKhpPfe4tA5YgecRgMZJv_fHAy492f2drcFq1CxJZBcaTVR5PHk1uu7F3xMvNu_y4-sENZ1YSPEFzFoJHQ_i7TpLRF9M3_cr08nensftLAIp5gXLQIkvI_ueYiYQDOPD4dgD8mGFsHTGgN2XVYjf2jTesHO00_oXvqP-8RYWowfS3ZXabnwzF-0EdxXWxkGdsLylPGe-T4tHTLhnWlCX8WjpH0TpF-fYv-PeYHhDYKOW3qQMBWwVetaQW2DKKViLJaNx8kK5MhIPoc_qNHBWq7y1s0Yyv5zBTUCVbTp79qEyB5hmVYPuOLv8ENKfnORhyUhLp6w6I8s-98FnQDYm9usIR-tHFrJGkWeqk26zo_k6J-Z5E5zt22eSKbYYT7V8p2RZuPLn96jUVAd-WjZZHwiOqX_mVVNYpIIobXjoiqh6vGA43aqekodXyf4pelU7PSW0EFGBuw=='
gui_template = b'gAAAAABcc7gmma_Yb6WFUpFArh0PIh_Kgkk-VGDURE7HRlIp81CwZZVBvozjzyFilBJfSM97lu9f3Ouxs1K06BH710g-W3O-HwehrTvTVGvdPloYKqGsI8wWkvdx7vBP0e-KL1dy1Ld_RuXcR0nrxb57dMIKbgc5EWkLHV82Zal1zapjPdwO0nJYKsmRzIomeDR6JrGvZ3ZOZuD7mxXAWxs9QOSfu7ovDYXpd4Zg1AB9MUrWxVLIn0DmYYb0NrCifS122HgGjyPEqMsPzI2X8bxCp0eD-JCczponz3z1_IT8j7jROLVsSFnFhYjwZmOd7bqoUhZ2_hgRpGFouQlLfgjxvFe62OClMNbkp3mkIiaQNhuTR9lWYyNjOQxtdF6hi8pBix5AvjuH5as4lyzlhHke7nsCrQDba8JGowKNeQxgoqWwDlXwWdHkKyCDSFCUbuFnzLUuq8HnV0t_MoHMtAesIE2lB7kOWdmpMhqwAZYfCX49QOyGm0tSPG1EZAoL3p3ozIlboxKd4aP3pVFJQoi4YIcEWImRQ1dfksYmoE87qvQzSwL6tT2hw_lQ03gOqIKAEP58SiYzTJlMoau5M1qXY1wlgLkmsyP_ql7lOn6PlbkJKcAuSm4XHFdlt5vdUjBipIdJfR0o9OxboIzdnp8QKp_zBmKjrp5hq3Maia-pUZLomnzPxo9_R3waP9ARZNT5kSD4hHM6MkM61cqfEn8ev9hPKsikmjDRdGjPnVVVunHmtMj9P6M5TsXD5-sO7ymFaT_pxul3GuxKZGKSrVGF1ceNWmZtUezvlpjUxYx6-TdjbMgHBWWlpNWi9Ffb2_7L8UwBxBs91BiESBnsYvh9WhnD4czwu8DWoNlPRyEVJuaOWVyZjergqywZTbooXXnLIb_PKwtLfyaaQRxBTiDPuIKWnqZgGaZlXlVNwuo5eYBxuZP059cNBRQxe2oJRzCZ94vIvCBhevwuN7Cdgay8ZviU91cByvPFu8OIQ-Ht2QH9MWc0Zdx8uXh9N9KGUKf_9FaAGSlfNiJBxhh4TmhgnhE9lbLBlSG5u7NyB67AHLzIk6b_EH7KcJjvQT7ZQ2DxLT8sRI7BomDanAbRY7lfZCtC1eC0EMJLMe8troNj4T0C37_PPRLl88QmF7BZwezHi-MeVxnqvTxUJQ2Fa0lmQqwM4DqUr8g9rjQ9WBIJ5mOvLbRPxn_M3xaBaGhH7UKLRSW5hStxZ5eBH1tiD2Xbge_iG_bFPS7O8Onfj5S88XwAHhQOSxBMcbKbIRtgXA9p8GROghvlZClnH0WAWr5YkJ9JJEo_BWofG7dxkdl6Rf_-cuygMFY0dCfSF6HWi6kS4iCgqIjsnUxqax-wS07HV3G6U9Lanq6KVsioaNZvD8OtIHDF42fpjpmHSdH1qu1wRZEYASkZsfe8GtqcW6WvPrMOHVtwTlswF9m64Ua4I22Qch-2UuGXqTL5GZYG53FzLrnziQ24nAmHsmNEpNB-0nXElRDzGfqwHbRDeuM0VatWWQDfJ5KHY_U6_i86XrQspTsz_5W6ozMvjxSs4FrodL8EJ1P7GE2tYLW-bRpmF4w1uFBhHWaRSbuY-blXLVqEzpHRw5JQ_iMF7BSymstldLW18P9e4huOoO9fGNpUwyT38c3LJh6Ffq4NcoIwQK-8RuSEzlGCIi3n84rBSR4M9k-Bvxc9FlPchx8Ya-va-4dHy_EarIIT8i3qnmlAs-Y7OL5SX7q59mixDBOgRjCEWuTQNW8YC4bP29gXFyLbhb76vQs-Oi2o9NyLsKmm5HOPuVtxEDzthBEE4_w9K3GmelDsfEliAG2E4F2uw8S4SprEuxeZRN3sPcX9NiqkdFH5i0lnLpXXx5N3Cqnt5kBk6LWmquRTgVV2DpOUJSU2jzSe21Ez-WhrsNqJeOeqK1HIxYrANSynlOUmmwhOHDii1PsoTTWhMvkn1cLL9PadbB0KjS_RudAIMPCbScWviPRoSMnQnRnYlcYi0FbxDymArj3EN394SHEd0eYHrzVvCYTQ5AtqyTmfQW8z0jNIUiFwARxoBNTkxR5Nn26-22ZL615umNIEA0yKXFRYYj39SGaspuZ_toHu1-kKj0P9-Eh_w9gqI2DZymraD3ADFvFP7rO7e7YMqNHQxVIq_jiRiMiUCBOVfptx_lllEKXCObsk0fx8zj6NCwvf5JGCiwXi5tUTClcMPb9gjcSyLF2wFId7yFb5F5VBz3pD_J3M_LS9m3h_NvMOEbBXHwYPgjyxLHSxTe92v9U2Cbyz5YdFrU0ad1RtVR9S2Tnyw3WX-O4abqBm1wd3tZRPqPHiHCke7Fd07BgpBdiY7LTBl-8lIZNTlAIhca1qVVtI93Y1aTg3nkUBasj9HBj3r60d8GKwZaMCDs05pLlU30jqhVVXhlqPGE87lY1T7ONAl2vDfQDyTRevUD1bB52TMgs_1y5c_v95ODRgZ90VAYQyYPJ9lSAmS2YsW8WatH-T07pbskqgFUvSgOJLKtzSh3ZTL3izeztgZv6fZZKcP1CgW8Fh5sJgX8YcQI91wVE23NSFMbPgtD6I36YFi6a8wX91Of_R7K1165om32djMZvq3rIu4rbr6O8tktVbVJTLAcRTbSNLnkIksrVUlXl4F1A0vkSPLrvuBTZ_yHClcOK3ytYSZbONlgbDXBJwVIw-MKBCXABDSC0oKgvDNCvC5KbTnmslpTA0vZjgI_RgoSRwsb5mY4FlCcccmXY57xzak3_ZpjtjLGtquamIC0Zvd_bHIaYsPtVUnHo4fpnrKJDDsUsJKSPcDipNoUdObXhwfKb3Br8mMSozBzJS1noj0huVRzQiRQaMYyTWPJ6qxO7_5gAnujzrpFxmWCieA4lR_u90Va642RFdFBH-2qlIDdSN9l4cfz7sR-NI2f8kL52xCjhEYPe2Nl00VWwUuLly_CTOWtut3qTukVJSTs-h07UeQHAyE5Hnnndefo_g3XzGLAhjblPK2NERSC5zeXIHnMfXoDYuEHr_V2qdyd9k8p1NZxfjPYVu8aTgPq9NmFXWHj_-EWrync460hDCpreBmZ6rcrCGnZrNzBMSRDqLbAvbl58dcWJLNiwfz7LWg5l0BkAIhLga0INdEP32rIOARNZVQOCNCE963CDKVOd0ewYLO1hHPukLJrruqASFhWkfYobzktOtTLSSZBtYRU2sDZ4oqcq8QUSertAtdl44VchQpo_sy0AfZ9MPg9VVvuObWKc6-lq04LGOYwh7fl0jAaOr_fWEuZh_i7kzFNFsMRXOi7Zvw0hLkJ30mQ5gnpZKp2Txl2qYj7CoH02GKkbeoaH6JQkDz1X_YT0z8y6qrWsYQcWWPCt4zYIXSOK0Yv28PuNfOWrnXMb0SWExBHKK5eCPwRi1fR_HpMu7udPvajCs9IfJE6bm8mYlaX8OGxVSAFfzoi0bTvhY7gup8P_pa5buEUE9AP477shoyg-bhx3zVHMGV7Rr3SJn1L0cBcGci5-GGXSAUSgXVLdq11mu5Tfeplm6LSb3LZNVv87OnaVU9ZFUpI-2ePsH0_-6UeNWE1Z79YCA_vuCg5TIMnip7O71rykxU5NdONqPpVybvWoa98vMcRLzwafbKYzX9t9Bj63TRPrIlkQ8jp09BObL_ZHbtkREjmw0R4V4uPxHAtB7nY9SwA-sF3pdrLr9MoLPlFkIkghjhK-ZqaW8Rn-TvTiab0ygserx5hqAgxMzVT008DnXKAEYXjMixLwWdCOpJgq8cQMQYH1DB7rFMFvuypLNjPG56wo6L-yL8tFGBB0CmzH5nfisvBioGQ=='
config_template = b'gAAAAABcam4IXxB5tsuLAWqnXGH4PQT0tEg8aU_gusJvhR5xEh56Aim_jjtcXmTz2EBJSM8_RPp_nAJvxEf4baDMtzTsBY95VLY-a6MMTRGSUlVOE4nsD5cgp95iXC6MNRYEGNFxYswTI_O8JZyYfF1bEaVz8ISlLlwFCCSHWqnC3MURYWISTXQ8-GXJAR5FDzPHP0A3nvPcP3b3kY8EPPZIW639cUdHNmQv6tr9zPKE3du5Wfe1tV3aEKIgtSVhwfHmI55ZrQ-cQ7Yrkxh740Y3T17CjYWSARSr9R3iA-YK1L1bKq6MgD8bgIP1Lg6tl9BZ1yyjZk3OZtSJmsbuzup_7RxjYY3fY1wKBDydM3GOL3MrE8nwZ3dehRiZzdQNFaJb0S-eK8qPw25NItQYXA4RPLrBJepU6PyuRCQNx5MReKODp1vWs_Wze7l8LhARMnfrBeYFA5vbfLqCXrdYqcDmOuRNV8uIhuLB5jREBsL9lToTuAuCjia1j9UejZejm4v3YNoztffu'
email_config_template = b'gAAAAABcam4qHlH4MHm2hjQV_XOgRFBTluMpHfiFmdXqGHBEUejBqBzB76elHTgZ2X1NT9ZCQMbk9w9XAJ7ZQEMA6SiX1Px-NMezp7F4HMI31Bia2-sPV5WtlCNJBsUaM8e0q4jMLqklBRy1-_nAkUxE4DVYjWVUvOTPcU1szIWWxFVFzjrS1Wpb8KZXR_vsYXDylTxrv5uwlMscCc_RrFANL3K8L-swbfVramykFcvnYhQHbgsqN_n7_MtQ8mfBpwTz6iNoCIC9'


def create_file(filename: str, text: bytes):
    cipher = get_cipher(cipher_key)
    with open(filename, 'w') as f:
        f.write(decrypt_str(text, cipher))


def create_console(filename: str = 'main.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, console_template)


def create_gui(filename: str = 'main_gui.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, gui_template)


def create_config(filename: str = 'settings.conf'):
    create_file(filename, config_template)


def add_email_config(filename: str = 'settings.conf'):
    try:
        with open(filename, 'r') as f:
            text = f.read()
        text += ',\n'
    except:
        text = ''
    cipher = get_cipher(cipher_key)
    text += decrypt_str(email_config_template, cipher)
    config_with_email_template = encrypt_str(text, cipher, get_str=False)
    create_file(filename, config_with_email_template)


if __name__ == '__main__':
    pass
