# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.meeting import Meeting
from ..types.meeting_list_response import MeetingListResponse
from .types.list_meetings_request_meeting_type import ListMeetingsRequestMeetingType


class RawMeetingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_meetings(
        self,
        *,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees_domains: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        include_crm_matches: typing.Optional[bool] = None,
        include_transcript: typing.Optional[bool] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Meeting]:
        """
        Parameters
        ----------
        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email address of calendar_invitees to filter by.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        calendar_invitees_domains : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Domains of the companies to filter by. Exact match.

            Pass the parameter once per value, e.g.
            `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

            Returns meetings where any of the given company domains appear in the meeting.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        created_before : typing.Optional[str]
            Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.

        cursor : typing.Optional[str]
            Cursor for pagination.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Meeting]
            Paginated list of meetings.
        """
        _response = self._client_wrapper.httpx_client.request(
            "meetings",
            method="GET",
            params={
                "calendar_invitees[]": calendar_invitees,
                "calendar_invitees_domains[]": calendar_invitees_domains,
                "created_after": created_after,
                "created_before": created_before,
                "cursor": cursor,
                "include_crm_matches": include_crm_matches,
                "include_transcript": include_transcript,
                "meeting_type": meeting_type,
                "recorded_by[]": recorded_by,
                "teams[]": teams,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    MeetingListResponse,
                    parse_obj_as(
                        type_=MeetingListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list_meetings(
                    calendar_invitees=calendar_invitees,
                    calendar_invitees_domains=calendar_invitees_domains,
                    created_after=created_after,
                    created_before=created_before,
                    cursor=_parsed_next,
                    include_crm_matches=include_crm_matches,
                    include_transcript=include_transcript,
                    meeting_type=meeting_type,
                    recorded_by=recorded_by,
                    teams=teams,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMeetingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_meetings(
        self,
        *,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees_domains: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        include_crm_matches: typing.Optional[bool] = None,
        include_transcript: typing.Optional[bool] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Meeting]:
        """
        Parameters
        ----------
        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email address of calendar_invitees to filter by.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        calendar_invitees_domains : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Domains of the companies to filter by. Exact match.

            Pass the parameter once per value, e.g.
            `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

            Returns meetings where any of the given company domains appear in the meeting.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        created_before : typing.Optional[str]
            Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.

        cursor : typing.Optional[str]
            Cursor for pagination.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Meeting]
            Paginated list of meetings.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "meetings",
            method="GET",
            params={
                "calendar_invitees[]": calendar_invitees,
                "calendar_invitees_domains[]": calendar_invitees_domains,
                "created_after": created_after,
                "created_before": created_before,
                "cursor": cursor,
                "include_crm_matches": include_crm_matches,
                "include_transcript": include_transcript,
                "meeting_type": meeting_type,
                "recorded_by[]": recorded_by,
                "teams[]": teams,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    MeetingListResponse,
                    parse_obj_as(
                        type_=MeetingListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list_meetings(
                        calendar_invitees=calendar_invitees,
                        calendar_invitees_domains=calendar_invitees_domains,
                        created_after=created_after,
                        created_before=created_before,
                        cursor=_parsed_next,
                        include_crm_matches=include_crm_matches,
                        include_transcript=include_transcript,
                        meeting_type=meeting_type,
                        recorded_by=recorded_by,
                        teams=teams,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
