# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.team import Team
from .raw_client import AsyncRawTeamsClient, RawTeamsClient


class TeamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTeamsClient
        """
        return self._raw_client

    def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncPager[Team]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Team]
            Paginated list of teams.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        response = client.teams.list_teams()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_teams(cursor=cursor, request_options=request_options)


class AsyncTeamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTeamsClient
        """
        return self._raw_client

    async def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPager[Team]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Team]
            Paginated list of teams.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            response = await client.teams.list_teams()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page
        asyncio.run(main())
        """
        return await self._raw_client.list_teams(cursor=cursor, request_options=request_options)
